/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.database;

import com.zeitheron.hammercore.utils.java.Hashers;
import java.util.Arrays;

public class SafeStore {
    public final byte[] store;

    public SafeStore(byte[] store) {
        this.store = store;
    }

    public boolean matches(byte[] contents) {
        return this.equals(SafeStore.of(contents));
    }

    public boolean matches(CharSequence contents) {
        return this.matches((contents + "").getBytes());
    }

    public boolean equals(Object a) {
        return a instanceof SafeStore && Arrays.equals(((SafeStore)a).store, this.store);
    }

    public static SafeStore of(CharSequence contents) {
        return SafeStore.of((contents + "").getBytes());
    }

    public static SafeStore of(byte[] contents) {
        return new SafeStore(Hashers.SHA256.hashifyRaw(contents));
    }
}

