/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.base;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class SideLocal<T> {
    private T client;
    private T server;

    public static <T> SideLocal<T> createEmpty() {
        return new SideLocal<T>();
    }

    public static <T> SideLocal<T> initializeSideBased(Function<Side, ? extends T> trade) {
        SideLocal<T> s = SideLocal.createEmpty();
        s.server = trade.apply(Side.SERVER);
        s.client = trade.apply(Side.CLIENT);
        return s;
    }

    public static <T> SideLocal<T> initializeSeparately(Supplier<? extends T> server, Supplier<? extends T> client2) {
        SideLocal<T> s = SideLocal.createEmpty();
        s.server = server.get();
        s.client = client2.get();
        return s;
    }

    public static <T> SideLocal<T> initializeForBoth(Supplier<? extends T> both) {
        SideLocal<T> s = SideLocal.createEmpty();
        s.server = both.get();
        s.client = both.get();
        return s;
    }

    public static <T> SideLocal<T> initializeForBothF(Function<Side, ? extends T> both) {
        SideLocal<T> s = SideLocal.createEmpty();
        s.server = both.apply(Side.SERVER);
        s.client = both.apply(Side.CLIENT);
        return s;
    }

    public static <T> SideLocal<T> withInitial(T server, T client2) {
        SideLocal<T> s = SideLocal.createEmpty();
        s.server = server;
        s.client = client2;
        return s;
    }

    public T get() {
        return this.get(this.getCurrentSide());
    }

    public void set(T data) {
        this.set(this.getCurrentSide(), data);
    }

    public T getAndSet(T data) {
        return this.getAndSet(this.getCurrentSide(), data);
    }

    public void apply(UnaryOperator<T> op) {
        this.apply(SideLocal.side(), op);
    }

    public boolean equalsTo(T value) {
        return Objects.equals(this.get(), value);
    }

    public T get(World level) {
        return this.get(LogicalSidePredictor.getCurrentLogicalSide(level));
    }

    public void set(World level, T data) {
        this.set(LogicalSidePredictor.getCurrentLogicalSide(level), data);
    }

    public T getAndSet(World level, T data) {
        return this.getAndSet(LogicalSidePredictor.getCurrentLogicalSide(level), data);
    }

    public void apply(World level, UnaryOperator<T> op) {
        this.apply(LogicalSidePredictor.getCurrentLogicalSide(level), op);
    }

    public boolean equalsTo(World level, T value) {
        return Objects.equals(this.get(level), value);
    }

    public T get(Side side) {
        if (side.isClient()) {
            return this.client;
        }
        return this.server;
    }

    public void set(Side side, T data) {
        if (side.isClient()) {
            this.client = data;
        } else {
            this.server = data;
        }
    }

    public T getAndSet(Side side, T data) {
        T prev = this.get(side);
        this.set(side, data);
        return prev;
    }

    public void apply(Side side, UnaryOperator<T> op) {
        this.set(side, op.apply(this.get(side)));
    }

    public boolean equalsTo(Side side, T value) {
        return Objects.equals(this.get(side), value);
    }

    public Side getCurrentSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static Side side() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public String toString() {
        return "SideLocal{client=" + this.client + ", server=" + this.server + '}';
    }
}

