/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.color;

import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.awt.Color;
import java.util.ArrayList;

public class ColorNamePicker {
    public static final ArrayList<Col> colorList = ColorNamePicker.initColorList();
    public static Col red;
    public static Col orange;
    public static Col yellow;
    public static Col lime;

    private static ArrayList<Col> initColorList() {
        ArrayList<Col> colorList = new ArrayList<Col>();
        colorList.add(new Col("AliceBlue", 240, 248, 255));
        colorList.add(new Col("AntiqueWhite", 250, 235, 215));
        colorList.add(new Col("Aqua", 0, 255, 255));
        colorList.add(new Col("Aquamarine", 127, 255, 212));
        colorList.add(new Col("Azure", 240, 255, 255));
        colorList.add(new Col("Beige", 245, 245, 220));
        colorList.add(new Col("Bisque", 255, 228, 196));
        colorList.add(new Col("Black", 0, 0, 0));
        colorList.add(new Col("BlanchedAlmond", 255, 235, 205));
        colorList.add(new Col("Blue", 0, 0, 255));
        colorList.add(new Col("BlueViolet", 138, 43, 226));
        colorList.add(new Col("Brown", 165, 42, 42));
        colorList.add(new Col("BurlyWood", 222, 184, 135));
        colorList.add(new Col("CadetBlue", 95, 158, 160));
        colorList.add(new Col("Chartreuse", 127, 255, 0));
        colorList.add(new Col("Chocolate", 210, 105, 30));
        colorList.add(new Col("Coral", 255, 127, 80));
        colorList.add(new Col("CornflowerBlue", 100, 149, 237));
        colorList.add(new Col("Cornsilk", 255, 248, 220));
        colorList.add(new Col("Crimson", 220, 20, 60));
        colorList.add(new Col("Cyan", 0, 255, 255));
        colorList.add(new Col("DarkBlue", 0, 0, 139));
        colorList.add(new Col("DarkCyan", 0, 139, 139));
        colorList.add(new Col("DarkGoldenRod", 184, 134, 11));
        colorList.add(new Col("DarkGray", 169, 169, 169));
        colorList.add(new Col("DarkGreen", 0, 100, 0));
        colorList.add(new Col("DarkKhaki", 189, 183, 107));
        colorList.add(new Col("DarkMagenta", 139, 0, 139));
        colorList.add(new Col("DarkOliveGreen", 85, 107, 47));
        colorList.add(new Col("DarkOrange", 255, 140, 0));
        colorList.add(new Col("DarkOrchid", 153, 50, 204));
        colorList.add(new Col("DarkRed", 139, 0, 0));
        colorList.add(new Col("DarkSalmon", 233, 150, 122));
        colorList.add(new Col("DarkSeaGreen", 143, 188, 143));
        colorList.add(new Col("DarkSlateBlue", 72, 61, 139));
        colorList.add(new Col("DarkSlateGray", 47, 79, 79));
        colorList.add(new Col("DarkTurquoise", 0, 206, 209));
        colorList.add(new Col("DarkViolet", 148, 0, 211));
        colorList.add(new Col("DeepPink", 255, 20, 147));
        colorList.add(new Col("DeepSkyBlue", 0, 191, 255));
        colorList.add(new Col("DimGray", 105, 105, 105));
        colorList.add(new Col("DodgerBlue", 30, 144, 255));
        colorList.add(new Col("FireBrick", 178, 34, 34));
        colorList.add(new Col("FloralWhite", 255, 250, 240));
        colorList.add(new Col("ForestGreen", 34, 139, 34));
        colorList.add(new Col("Fuchsia", 255, 0, 255));
        colorList.add(new Col("Gainsboro", 220, 220, 220));
        colorList.add(new Col("GhostWhite", 248, 248, 255));
        colorList.add(new Col("Gold", 255, 215, 0));
        colorList.add(new Col("GoldenRod", 218, 165, 32));
        colorList.add(new Col("Gray", 128, 128, 128));
        colorList.add(new Col("Green", 0, 128, 0));
        colorList.add(new Col("GreenYellow", 173, 255, 47));
        colorList.add(new Col("HoneyDew", 240, 255, 240));
        colorList.add(new Col("HotPink", 255, 105, 180));
        colorList.add(new Col("IndianRed", 205, 92, 92));
        colorList.add(new Col("Indigo", 75, 0, 130));
        colorList.add(new Col("Ivory", 255, 255, 240));
        colorList.add(new Col("Khaki", 240, 230, 140));
        colorList.add(new Col("Lavender", 230, 230, 250));
        colorList.add(new Col("LavenderBlush", 255, 240, 245));
        colorList.add(new Col("LawnGreen", 124, 252, 0));
        colorList.add(new Col("LemonChiffon", 255, 250, 205));
        colorList.add(new Col("LightBlue", 173, 216, 230));
        colorList.add(new Col("LightCoral", 240, 128, 128));
        colorList.add(new Col("LightCyan", 224, 255, 255));
        colorList.add(new Col("LightGoldenRodYellow", 250, 250, 210));
        colorList.add(new Col("LightGray", 211, 211, 211));
        colorList.add(new Col("LightGreen", 144, 238, 144));
        colorList.add(new Col("LightPink", 255, 182, 193));
        colorList.add(new Col("LightSalmon", 255, 160, 122));
        colorList.add(new Col("LightSeaGreen", 32, 178, 170));
        colorList.add(new Col("LightSkyBlue", 135, 206, 250));
        colorList.add(new Col("LightSlateGray", 119, 136, 153));
        colorList.add(new Col("LightSteelBlue", 176, 196, 222));
        colorList.add(new Col("LightYellow", 255, 255, 224));
        lime = new Col("Lime", 0, 255, 0);
        colorList.add(lime);
        colorList.add(new Col("LimeGreen", 50, 205, 50));
        colorList.add(new Col("Linen", 250, 240, 230));
        colorList.add(new Col("Magenta", 255, 0, 255));
        colorList.add(new Col("Maroon", 128, 0, 0));
        colorList.add(new Col("MediumAquaMarine", 102, 205, 170));
        colorList.add(new Col("MediumBlue", 0, 0, 205));
        colorList.add(new Col("MediumOrchid", 186, 85, 211));
        colorList.add(new Col("MediumPurple", 147, 112, 219));
        colorList.add(new Col("MediumSeaGreen", 60, 179, 113));
        colorList.add(new Col("MediumSlateBlue", 123, 104, 238));
        colorList.add(new Col("MediumSpringGreen", 0, 250, 154));
        colorList.add(new Col("MediumTurquoise", 72, 209, 204));
        colorList.add(new Col("MediumVioletRed", 199, 21, 133));
        colorList.add(new Col("MidnightBlue", 25, 25, 112));
        colorList.add(new Col("MintCream", 245, 255, 250));
        colorList.add(new Col("MistyRose", 255, 228, 225));
        colorList.add(new Col("Moccasin", 255, 228, 181));
        colorList.add(new Col("NavajoWhite", 255, 222, 173));
        colorList.add(new Col("Navy", 0, 0, 128));
        colorList.add(new Col("OldLace", 253, 245, 230));
        colorList.add(new Col("Olive", 128, 128, 0));
        colorList.add(new Col("OliveDrab", 107, 142, 35));
        orange = new Col("Orange", 255, 165, 0);
        colorList.add(orange);
        colorList.add(new Col("OrangeRed", 255, 69, 0));
        colorList.add(new Col("Orchid", 218, 112, 214));
        colorList.add(new Col("PaleGoldenRod", 238, 232, 170));
        colorList.add(new Col("PaleGreen", 152, 251, 152));
        colorList.add(new Col("PaleTurquoise", 175, 238, 238));
        colorList.add(new Col("PaleVioletRed", 219, 112, 147));
        colorList.add(new Col("PapayaWhip", 255, 239, 213));
        colorList.add(new Col("PeachPuff", 255, 218, 185));
        colorList.add(new Col("Peru", 205, 133, 63));
        colorList.add(new Col("Pink", 255, 192, 203));
        colorList.add(new Col("Plum", 221, 160, 221));
        colorList.add(new Col("PowderBlue", 176, 224, 230));
        colorList.add(new Col("Purple", 128, 0, 128));
        red = new Col("Red", 255, 0, 0);
        colorList.add(red);
        colorList.add(new Col("RosyBrown", 188, 143, 143));
        colorList.add(new Col("RoyalBlue", 65, 105, 225));
        colorList.add(new Col("SaddleBrown", 139, 69, 19));
        colorList.add(new Col("Salmon", 250, 128, 114));
        colorList.add(new Col("SandyBrown", 244, 164, 96));
        colorList.add(new Col("SeaGreen", 46, 139, 87));
        colorList.add(new Col("SeaShell", 255, 245, 238));
        colorList.add(new Col("Sienna", 160, 82, 45));
        colorList.add(new Col("Silver", 192, 192, 192));
        colorList.add(new Col("SkyBlue", 135, 206, 235));
        colorList.add(new Col("SlateBlue", 106, 90, 205));
        colorList.add(new Col("SlateGray", 112, 128, 144));
        colorList.add(new Col("Snow", 255, 250, 250));
        colorList.add(new Col("SpringGreen", 0, 255, 127));
        colorList.add(new Col("SteelBlue", 70, 130, 180));
        colorList.add(new Col("Tan", 210, 180, 140));
        colorList.add(new Col("Teal", 0, 128, 128));
        colorList.add(new Col("Thistle", 216, 191, 216));
        colorList.add(new Col("Tomato", 255, 99, 71));
        colorList.add(new Col("Turquoise", 64, 224, 208));
        colorList.add(new Col("Violet", 238, 130, 238));
        colorList.add(new Col("Wheat", 245, 222, 179));
        colorList.add(new Col("White", 255, 255, 255));
        colorList.add(new Col("WhiteSmoke", 245, 245, 245));
        yellow = new Col("Yellow", 255, 255, 0);
        colorList.add(yellow);
        colorList.add(new Col("YellowGreen", 154, 205, 50));
        for (Col c : colorList) {
            String fi = c.name;
            char[] name = fi.toCharArray();
            int off = 0;
            boolean first = true;
            for (int i = 0; i < name.length; ++i) {
                if (!Character.isUpperCase(name[i])) continue;
                if (first) {
                    first = false;
                    continue;
                }
                fi = fi.substring(0, i + off) + " " + fi.substring(i + off);
                ++off;
            }
            c.name = fi;
        }
        return colorList;
    }

    public static String getColorNameFromRgb(int r, int g, int b) {
        Col closestMatch = null;
        int minMSE = Integer.MAX_VALUE;
        for (Col c : colorList) {
            int mse = c.computeMSE(r, g, b);
            if (mse >= minMSE) continue;
            minMSE = mse;
            closestMatch = c;
        }
        if (closestMatch != null) {
            return closestMatch.getName();
        }
        return "No matched color name.";
    }

    public static String getColorNameFromHex(int hexColor) {
        int r = (int)(ColorHelper.getRed(hexColor) * 255.0f);
        int g = (int)(ColorHelper.getGreen(hexColor) * 255.0f);
        int b = (int)(ColorHelper.getBlue(hexColor) * 255.0f);
        return ColorNamePicker.getColorNameFromRgb(r, g, b);
    }

    public static int colorToHex(Color c) {
        return Integer.decode("0x" + Integer.toHexString(c.getRGB()).substring(2));
    }

    public static String getColorNameFromColor(Color color) {
        return ColorNamePicker.getColorNameFromRgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Integer trySearchColorFor(String name) {
        for (Col c : colorList) {
            if (!c.name.equalsIgnoreCase(name)) continue;
            return c.getRGB();
        }
        try {
            return Integer.parseInt(name, 16);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static class Col {
        public int r;
        public int g;
        public int b;
        public String name;

        public Col(String name, int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.name = name;
        }

        public int computeMSE(int rgb) {
            return this.computeMSE((int)(ColorHelper.getRed(rgb) * 255.0f), (int)(ColorHelper.getGreen(rgb) * 255.0f), (int)(ColorHelper.getBlue(rgb) * 255.0f));
        }

        public int computeMSE(int pixR, int pixG, int pixB) {
            return ((pixR - this.r) * (pixR - this.r) + (pixG - this.g) * (pixG - this.g) + (pixB - this.b) * (pixB - this.b)) / 3;
        }

        public int getRGB() {
            return ColorHelper.packRGB((float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f);
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }

        public String getName() {
            return this.name;
        }
    }
}

