/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.forge;

import com.zeitheron.hammercore.utils.IRegisterListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterHook {

    public static class HookCollector {
        public static void propagate(IRegisterListener inst) {
            HookCollector.propagateInstance(inst.getClass(), inst);
        }

        private static void propagateInstance(Class<?> cls, IRegisterListener inst) {
            if (cls == null || cls.equals(Object.class)) {
                return;
            }
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(RegisterHook.class) || method.getParameterCount() != 0) continue;
                method.setAccessible(true);
                try {
                    method.invoke((Object)inst, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            HookCollector.propagateInstance(cls.getSuperclass(), inst);
        }
    }
}

