/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java;

import com.zeitheron.hammercore.utils.java.RateTicker;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class Fetcher<T>
implements Supplier<T> {
    private final Supplier<T> fetch;
    private final BooleanSupplier shouldRefetch;
    private boolean cached = false;
    private T cache;
    private static final BooleanSupplier ALWAYS_FALSE = () -> false;

    public Fetcher(Supplier<T> fetch, BooleanSupplier shouldRefetch) {
        this.fetch = fetch;
        this.shouldRefetch = shouldRefetch;
    }

    @Override
    public T get() {
        if (!this.cached || this.shouldRefetch.getAsBoolean()) {
            this.cache = this.fetch.get();
            this.cached = true;
        }
        return this.cache;
    }

    public static <T> Fetcher<T> fetchOnce(Supplier<T> origin) {
        return new Fetcher<T>(origin, ALWAYS_FALSE);
    }

    public static <T> Fetcher<T> refetchAtRate(Supplier<T> origin, long refetchTime, TimeUnit refetchUnit) {
        return new Fetcher<T>(origin, new RateTicker(refetchTime, refetchUnit));
    }
}

