/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.net.properties.IBasePropertyHolder;

@MainThreaded
public class SendPropertiesPacket
implements IPacket {
    private static final Logger LOG = LogManager.getLogger();
    IObjectSource<?> source;
    byte[] data;

    public SendPropertiesPacket(IObjectSource<?> source, byte[] data) {
        this.source = source;
        this.data = data;
    }

    public SendPropertiesPacket() {
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150786_a(IObjectSource.writeSource(this.source));
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }

    @Override
    public void read(PacketBuffer buf) throws IOException {
        this.source = IObjectSource.readSource(buf.func_150793_b()).orElse(null);
        this.data = new byte[buf.readShort()];
        buf.readBytes(this.data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeOnClient2(PacketContext net) {
        IBasePropertyHolder tile;
        WorldClient cw = Minecraft.func_71410_x().field_71441_e;
        if (cw != null && this.source != null && (tile = (IBasePropertyHolder)this.source.get(IBasePropertyHolder.class, (World)cw).orElse(null)) != null) {
            PacketBuffer buf = new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.data));
            try {
                tile.getProperties().decodeChanges(buf);
            }
            catch (IOException e) {
                LOG.error("Failed to decode changes inside {}", (Object)tile, (Object)e);
            }
        }
    }
}

