/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.zeitheron.hammercore.utils.java.DirectStorage;
import java.util.Objects;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;

public abstract class PropertyBase<T>
implements IProperty<T> {
    protected PropertyDispatcher dispatcher;
    protected boolean changed;
    protected final DirectStorage<T> value;
    protected final Class<T> type;

    public PropertyBase(Class<T> type, DirectStorage<T> value) {
        this.type = type;
        this.value = value;
    }

    public PropertyBase(Class<T> type) {
        this(type, DirectStorage.allocate());
    }

    protected boolean differ(T a, T b) {
        return !Objects.equals(a, b);
    }

    public DirectStorage<T> getStorage() {
        return this.value;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T set(T value) {
        T pv = this.value.get();
        if (this.differ(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public T get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        if (this.dispatcher == null) {
            this.dispatcher = dispatcher;
        }
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.get() + "}";
    }
}

