/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import io.netty.buffer.ByteBuf;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHatFragment
extends AbstractPacket {
    public String hatName;
    public byte packetTotal;
    public byte packetNumber;
    public int fileSize;
    public byte[] data;

    public PacketHatFragment() {
    }

    public PacketHatFragment(String name, int pktTotal, int pktNum, int fSize, byte[] dataArray) {
        this.hatName = name;
        this.packetTotal = (byte)pktTotal;
        this.packetNumber = (byte)pktNum;
        this.fileSize = fSize;
        this.data = dataArray;
    }

    public void writeTo(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.hatName);
        buffer.writeByte((int)this.packetTotal);
        buffer.writeByte((int)this.packetNumber);
        buffer.writeInt(this.fileSize);
        buffer.writeBytes(this.data);
    }

    public void readFrom(ByteBuf buffer) {
        this.hatName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.packetTotal = buffer.readByte();
        this.packetNumber = buffer.readByte();
        this.fileSize = buffer.readInt();
        this.data = new byte[this.fileSize];
        buffer.readBytes(this.data);
    }

    public void execute(Side side, EntityPlayer player) {
        HatHandler.receiveHatData(this.hatName, this.packetTotal, this.packetNumber, this.data, (EntityPlayer)(side.isServer() ? player : null), side.isServer());
    }

    public Side receivingSide() {
        return null;
    }
}

