/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.renderers;

import com.mojang.authlib.GameProfile;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.ModelHead;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockSkull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityBlockSkullRenderer
extends TileEntitySpecialRenderer<TileEntityBlockSkull> {
    public static final TileEntityBlockSkullRenderer INSTANCE = new TileEntityBlockSkullRenderer();
    private ModelHead model;

    public void func_192841_a(TileEntityBlockSkull tile, double x, double y, double z, float partialTickTime, int destroyStage, float p_192841_10_) {
        this.renderHead((float)x, (float)y, (float)z, tile.func_145832_p() & 7, (float)(tile.func_145906_b() * 360) / 16.0f, tile.getModel(), tile.func_152108_a(), destroyStage);
    }

    public void renderHead(float x, float y, float z, int meta, float skullRotation, SkullTypes type, GameProfile profile, int destroyStage) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(type.getTexture(profile));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        this.translateHead(x, y, z, meta);
        skullRotation = this.adjustRotation(meta, skullRotation);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.model = type.model();
        this.model.preRender(profile);
        this.model.render(skullRotation);
        this.renderSpecial(profile, skullRotation);
        if (GL11.glIsEnabled((int)3042)) {
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    private void renderSpecial(GameProfile profile, float skullRotation) {
        ResourceLocation secondTex = this.model.getSecondTexture();
        if (secondTex != null) {
            this.func_147499_a(secondTex);
        }
        this.model.renderSpecial(profile, skullRotation);
    }

    private void translateHead(float x, float y, float z, int meta) {
        switch (meta) {
            case 1: {
                GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
                break;
            }
            case 2: {
                GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.74f));
                break;
            }
            case 3: {
                GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.26f));
                break;
            }
            case 4: {
                GlStateManager.func_179109_b((float)(x + 0.74f), (float)(y + 0.25f), (float)(z + 0.5f));
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)(x + 0.26f), (float)(y + 0.25f), (float)(z + 0.5f));
            }
        }
    }

    private float adjustRotation(int meta, float rotation) {
        switch (meta) {
            case 1: 
            case 2: {
                return rotation;
            }
            case 3: {
                return 180.0f;
            }
            case 4: {
                return 270.0f;
            }
        }
        return 90.0f;
    }
}

