/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.gui.recipe;

import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.Focus;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.GuiFluidStackGroup;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiIngredientGroup;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.recipes.ShapelessIcon;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipePreviewWidget
implements IRecipeLayoutDrawable {
    private static final int RECIPE_BORDER_PADDING = 4;
    private final int ingredientCycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
    private final IRecipeCategory recipeCategory;
    private final Map<IIngredientType, GuiIngredientGroup> guiIngredientGroups;
    private final IRecipeWrapper recipeWrapper;
    @Nullable
    private final IFocus<?> focus;
    private final Color highlightColor = new Color(Integer.MAX_VALUE, true);
    @Nullable
    private ShapelessIcon shapelessIcon;
    private IRecipeTransferError transferError;
    private final DrawableNineSliceTexture recipeBorder;
    private int posX;
    private int posY;

    @Nullable
    public static <T extends IRecipeWrapper> RecipePreviewWidget create(IRecipeCategory<T> recipeCategory, T recipeWrapper, @Nullable IFocus focus, int posX, int posY) {
        RecipePreviewWidget recipeLayout = new RecipePreviewWidget(recipeCategory, recipeWrapper, focus, posX, posY);
        try {
            Ingredients ingredients = new Ingredients();
            recipeWrapper.getIngredients((IIngredients)ingredients);
            recipeCategory.setRecipe((IRecipeLayout)recipeLayout, recipeWrapper, (IIngredients)ingredients);
            return recipeLayout;
        }
        catch (LinkageError | RuntimeException e) {
            Log.get().error("Error caught from Recipe Category: {}", (Object)recipeCategory.getClass().getCanonicalName(), (Object)e);
            return null;
        }
    }

    public static RecipePreviewWidget createLayout(RecipeInfo<?, ?> recipeInfo, int posX, int posY) {
        return RecipePreviewWidget.create(JeiUtilitiesPlugin.recipeRegistry.getRecipeCategory(recipeInfo.getRecipeCategoryUid()), recipeInfo.getRecipeWrapper(), (IFocus)new Focus(recipeInfo.getMode(), recipeInfo.getIngredient()), posX, posY);
    }

    private <T extends IRecipeWrapper> RecipePreviewWidget(IRecipeCategory<T> recipeCategory, T recipeWrapper, @Nullable IFocus<?> focus, int posX, int posY) {
        ErrorUtil.checkNotNull(recipeCategory, (String)"recipeCategory");
        ErrorUtil.checkNotNull(recipeWrapper, (String)"recipeWrapper");
        if (focus != null) {
            focus = Focus.check(focus);
        }
        this.recipeCategory = recipeCategory;
        this.focus = focus;
        Focus itemStackFocus = null;
        Focus fluidStackFocus = null;
        if (focus != null) {
            Object focusValue = focus.getValue();
            if (focusValue instanceof ItemStack) {
                itemStackFocus = focus;
            } else if (focusValue instanceof FluidStack) {
                fluidStackFocus = focus;
            }
        }
        this.guiIngredientGroups = new IdentityHashMap<IIngredientType, GuiIngredientGroup>();
        GuiItemStackGroup itemStackGroup = new GuiItemStackGroup((IFocus)itemStackFocus, this.ingredientCycleOffset){

            public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset, @Nonnull Color highlightColor, int mouseX, int mouseY) {
                for (GuiIngredient ingredient : super.getGuiIngredients().values()) {
                    ingredient.draw(minecraft, xOffset, yOffset);
                }
            }
        };
        GuiFluidStackGroup fluidStackGroup = new GuiFluidStackGroup((IFocus)fluidStackFocus, this.ingredientCycleOffset){

            public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset, @Nonnull Color highlightColor, int mouseX, int mouseY) {
                for (GuiIngredient ingredient : super.getGuiIngredients().values()) {
                    ingredient.draw(minecraft, xOffset, yOffset);
                }
            }
        };
        this.guiIngredientGroups.put(VanillaTypes.ITEM, (GuiIngredientGroup)itemStackGroup);
        this.guiIngredientGroups.put(VanillaTypes.FLUID, (GuiIngredientGroup)fluidStackGroup);
        this.setPosition(posX, posY);
        this.recipeWrapper = recipeWrapper;
        this.recipeBorder = Internal.getHelpers().getGuiHelper().getRecipeBackground();
    }

    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public void drawRecipe(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        int width = background.getWidth() + 8;
        int height = background.getHeight() + 8;
        this.checkBounds(minecraft.field_71462_r, height);
        float scaling = JeiUtilitiesConfig.isAdaptiveRecipePreview() ? this.getScaling(minecraft.field_71462_r) : JeiUtilitiesConfig.getRecipePreviewScaling();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.posX * scaling), (float)((float)this.posY * scaling), (float)0.0f);
        GlStateManager.func_179152_a((float)scaling, (float)scaling, (float)1.0f);
        this.recipeBorder.draw(minecraft, -4, -4, width, height);
        background.draw(minecraft);
        this.recipeCategory.drawExtras(minecraft);
        this.recipeWrapper.drawInfo(minecraft, background.getWidth(), background.getHeight(), recipeMouseX, recipeMouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(minecraft, background.getWidth());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        GlStateManager.func_179152_a((float)scaling, (float)scaling, (float)1.0f);
        for (GuiIngredientGroup guiIngredientGroup : this.guiIngredientGroups.values()) {
            guiIngredientGroup.draw(minecraft, this.posX, this.posY, this.highlightColor, mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
    }

    private float getScaling(GuiScreen guiScreen) {
        if (guiScreen != null) {
            IDrawable categoryBackground = this.recipeCategory.getBackground();
            int backgroundWidth = categoryBackground.getWidth() + 8;
            int backgroundHeight = categoryBackground.getHeight() + 8;
            int maxWidth = guiScreen.field_146294_l / 2;
            int maxHeight = guiScreen.field_146295_m / 2;
            if (backgroundWidth > maxWidth && backgroundHeight > maxHeight) {
                return (float)maxWidth / (float)backgroundWidth + 0.1f;
            }
            if ((double)backgroundWidth < (double)maxWidth * 0.5 && (double)backgroundHeight < (double)maxHeight * 0.5) {
                return (float)maxWidth / (float)backgroundWidth - 0.2f;
            }
            if (backgroundWidth < maxWidth && backgroundHeight > maxHeight) {
                return (float)maxHeight / (float)backgroundHeight + 0.2f;
            }
            if (backgroundWidth >= maxWidth && backgroundHeight < maxHeight) {
                return 1.0f;
            }
            return 0.95f;
        }
        return JeiUtilitiesConfig.getRecipePreviewScaling();
    }

    private void checkBounds(GuiScreen guiScreen, int height) {
        if (guiScreen != null) {
            if (this.posX < 6) {
                this.posX += 6;
            }
            if (this.posY < 6) {
                this.posY += 6;
            }
            if (this.posY + height > guiScreen.field_146295_m) {
                this.posY -= this.posY + height - guiScreen.field_146295_m;
            }
        }
    }

    public void drawOverlays(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        Rectangle backgroundRect = new Rectangle(this.posX, this.posY, background.getWidth(), background.getHeight());
        return backgroundRect.contains(mouseX, mouseY);
    }

    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        return null;
    }

    public void draw(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        this.drawRecipe(minecraft, mouseX, mouseY);
        this.drawOverlays(minecraft, mouseX, mouseY);
    }

    public IRecipeTransferError getTransferError() {
        return this.transferError;
    }

    public IRecipeTransferError transferRecipe(Container container, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime == null) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        RecipeRegistry recipeRegistry = runtime.getRecipeRegistry();
        IRecipeTransferHandler transferHandler = recipeRegistry.getRecipeTransferHandler(container, this.recipeCategory);
        if (transferHandler == null) {
            if (doTransfer) {
                Log.get().error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return RecipeTransferErrorInternal.INSTANCE;
        }
        this.transferError = transferHandler.transferRecipe(container, (IRecipeLayout)this, player, maxTransfer, doTransfer);
        return this.transferError;
    }

    public void showError(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.transferError != null) {
            float scaling = JeiUtilitiesConfig.isAdaptiveRecipePreview() ? this.getScaling(minecraft.field_71462_r) : JeiUtilitiesConfig.getRecipePreviewScaling();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scaling, (float)scaling, (float)1.0f);
            this.transferError.showError(minecraft, mouseX, mouseY, (IRecipeLayout)this, this.posX, this.posY);
            GlStateManager.func_179121_F();
        }
    }

    @Nonnull
    public IGuiItemStackGroup getItemStacks() {
        return (IGuiItemStackGroup)this.guiIngredientGroups.get(VanillaTypes.ITEM);
    }

    @Nonnull
    public IGuiFluidStackGroup getFluidStacks() {
        return (IGuiFluidStackGroup)this.guiIngredientGroups.get(VanillaTypes.FLUID);
    }

    @Nonnull
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(@Nonnull IIngredientType<T> ingredientType) {
        GuiIngredientGroup guiIngredientGroup = this.guiIngredientGroups.get(ingredientType);
        if (guiIngredientGroup == null) {
            IFocus<?> focus = null;
            if (this.focus != null) {
                Object focusValue = this.focus.getValue();
                if (ingredientType.getIngredientClass().isInstance(focusValue)) {
                    focus = this.focus;
                }
            }
            guiIngredientGroup = new GuiIngredientGroup<T>(ingredientType, focus, this.ingredientCycleOffset){

                public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset, @Nonnull Color highlightColor, int mouseX, int mouseY) {
                    for (GuiIngredient ingredient : super.getGuiIngredients().values()) {
                        ingredient.draw(minecraft, xOffset, yOffset);
                    }
                }
            };
            this.guiIngredientGroups.put(ingredientType, guiIngredientGroup);
        }
        return guiIngredientGroup;
    }

    @Nonnull
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(@Nonnull Class<T> ingredientClass) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        return this.getIngredientsGroup(ingredientType);
    }

    @Nullable
    public IFocus<?> getFocus() {
        return this.focus;
    }

    @Nonnull
    public IRecipeCategory<?> getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setRecipeTransferButton(int posX, int posY) {
    }

    public void setShapeless() {
        this.shapelessIcon = new ShapelessIcon();
    }
}

