/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.crafttweaker;

import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrusherRecipeRemoveAction
implements IAction {
    private final ItemStack output;
    private final ItemStack input;

    public CrusherRecipeRemoveAction(ItemStack input, @Nullable ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public void apply() {
        ICrusherRecipe recipe = CrusherRecipeRegistry.getRecipeForInputItem(this.input);
        if (recipe != null) {
            if (this.output != ItemStack.field_190927_a && OreDictionary.itemMatches((ItemStack)recipe.getOutput(), (ItemStack)this.output, (boolean)false) && recipe.getOutput().func_190916_E() == this.output.func_190916_E() || this.output == ItemStack.field_190927_a) {
                CrusherRecipeRegistry.removeByName(recipe.getRegistryName());
            } else {
                String mess = String.format("Recipe with input %s(*%d)", this.input.func_82833_r(), this.input.func_190916_E());
                if (this.output != ItemStack.field_190927_a) {
                    mess = mess + String.format(" and output of %s(*%d)", this.output.func_82833_r(), this.output.func_190916_E());
                }
                CraftTweakerAPI.logInfo((String)String.format("%s not found, ignoring", mess));
            }
        } else {
            String mess = String.format("Recipe with input %s(*%d)", this.input.func_82833_r(), this.input.func_190916_E());
            if (this.output != null) {
                mess = mess + String.format(" and output of %s(*%d)", this.output.func_82833_r(), this.output.func_190916_E());
            }
            CraftTweakerAPI.logInfo((String)String.format("%s not found, ignoring", mess));
        }
    }

    public String describe() {
        return String.format("Recipe for %s(*%d) has been removed", this.input.func_82833_r(), this.input.func_190916_E());
    }
}

