/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.capability.ICapabilitiesContainer;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.InventoryGrid;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.container.widget.ItemStackHandlerWidget;
import com.mcmoddev.lib.feature.BaseFeature;
import com.mcmoddev.lib.feature.IClientFeature;
import com.mcmoddev.lib.inventory.FilteredItemHandler;
import com.mcmoddev.lib.inventory.ItemHandlerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemInventoryFeature
extends BaseFeature
implements IClientFeature,
IWidgetContainer,
ICapabilityProvider {
    private final IItemHandlerModifiable internalHandler;
    private final FilteredItemHandler externalHandler;
    private int overlayColor = -1;
    private int overlayAlpha = -1;
    private int columns = 9;

    public ItemInventoryFeature(String key, int slots) {
        this(key, slots, null, null);
    }

    public ItemInventoryFeature(String key, int slots, @Nullable BiPredicate<Integer, ItemStack> insertFilter, @Nullable BiPredicate<Integer, ItemStack> extractFilter) {
        this(key, (IItemHandlerModifiable)new ItemStackHandler(slots), insertFilter, extractFilter);
    }

    public ItemInventoryFeature(String key, IItemHandlerModifiable handler, @Nullable BiPredicate<Integer, ItemStack> insertFilter, @Nullable BiPredicate<Integer, ItemStack> extractFilter) {
        super(key);
        this.internalHandler = new ItemHandlerWrapper(handler){

            @Override
            protected void onChanged(int slot) {
                ItemInventoryFeature.this.setDirty();
            }
        };
        this.externalHandler = new FilteredItemHandler(this.internalHandler, insertFilter, extractFilter);
    }

    public IItemHandlerModifiable getInternalHandler() {
        return this.internalHandler;
    }

    public IItemHandlerModifiable getExternalHandler() {
        return this.externalHandler;
    }

    @Override
    protected void writeToNBT(NBTTagCompound tag) {
        if (this.internalHandler instanceof INBTSerializable) {
            INBTSerializable serializable = (INBTSerializable)this.internalHandler;
            tag.func_74782_a("stacks", serializable.serializeNBT());
        }
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.internalHandler instanceof INBTSerializable) {
            INBTSerializable serializable = (INBTSerializable)this.internalHandler;
            if (nbt.func_150297_b("stacks", 10)) {
                NBTTagCompound stacksNBT = nbt.func_74775_l("stacks");
                serializable.deserializeNBT((NBTBase)stacksNBT);
            } else {
                for (int slot = 0; slot < this.internalHandler.getSlots(); ++slot) {
                    this.internalHandler.setStackInSlot(slot, ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public void initCapabilities(ICapabilitiesContainer container) {
        container.addCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f -> this.externalHandler);
    }

    public ItemInventoryFeature setOverlayColor(int color) {
        this.overlayColor = color;
        this.overlayAlpha = -1;
        return this;
    }

    public ItemInventoryFeature setOverlayColor(int color, int alpha) {
        this.overlayColor = color;
        this.overlayAlpha = alpha;
        return this;
    }

    public int getColumns() {
        return this.columns;
    }

    public ItemInventoryFeature setColumns(int columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public List<IWidget> getWidgets(GuiContext context) {
        return new ArrayList<IWidget>(){
            {
                this.add(new ItemStackHandlerWidget(ItemInventoryFeature.this.getKey() + "_slots", ItemInventoryFeature.this.internalHandler, ItemInventoryFeature.this.externalHandler));
            }
        };
    }

    @Override
    public IWidgetGui getRootWidgetGui(GuiContext context) {
        InventoryGrid grid = new InventoryGrid(this.columns, this.getKey() + "_slots");
        if (this.overlayColor != -1) {
            if (this.overlayAlpha > -1) {
                grid.setColorOverlay(this.overlayColor, this.overlayAlpha);
            } else {
                grid.setColorOverlay(this.overlayColor);
            }
        }
        return grid;
    }

    @Override
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        return null;
    }

    @Override
    @Nullable
    public NBTTagCompound getLoadUpdateTag() {
        return super.getLoadUpdateTag();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getExternalHandler());
        }
        return null;
    }
}

