/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.util.Config;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.commons.lang3.tuple.Triple;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnderIO
implements IIntegration {
    public static final String PLUGIN_MODID = "enderio";
    private static final String NS_URI = "http://enderio.com/recipes";
    private static final String NS_SCHEMA = "http://enderio.com/recipes recipes.xsd";
    private static final String FORMAT_STRING = "%s: %s to %s";

    @Override
    public void init() {
        if (!Config.Options.isModEnabled(PLUGIN_MODID)) {
            return;
        }
    }

    protected static void addAlloySmelterRecipe(@Nonnull String materialName) {
        EnderIO.addAlloySmelterRecipe(Materials.getMaterialByName(materialName), null, 2000);
    }

    protected static void addAlloySmelterRecipe(@Nonnull MMDMaterial material) {
        EnderIO.addAlloySmelterRecipe(material, null, 2000);
    }

    protected static void addAlloySmelterRecipe(@Nonnull String materialName, @Nonnull int energy) {
        EnderIO.addAlloySmelterRecipe(Materials.getMaterialByName(materialName), null, energy);
    }

    protected static void addAlloySmelterRecipe(@Nonnull MMDMaterial material, @Nonnull int energy) {
        EnderIO.addAlloySmelterRecipe(material, null, energy);
    }

    protected static void addAlloySmelterRecipe(@Nonnull String materialName, String outputSecondary, @Nonnull int energy) {
        EnderIO.addAlloySmelterRecipe(Materials.getMaterialByName(materialName), outputSecondary, energy);
    }

    protected static void addAlloySmelterRecipe(@Nonnull MMDMaterial material, @Nullable String outputSecondary, @Nonnull int energy) {
        String ownerModID = Loader.instance().activeModContainer().getModId();
        String capitalizedName = material.getCapitalizedName();
        String input = "ore" + capitalizedName;
        String output = "ingot" + capitalizedName;
        if (!material.hasOre()) {
            return;
        }
        ArrayList<Triple<String, Integer, Float>> rec = new ArrayList<Triple<String, Integer, Float>>();
        rec.add(Triple.of((Object)input, (Object)1, (Object)Float.valueOf(0.0f)));
        rec.add(Triple.of((Object)output, (Object)2, (Object)Float.valueOf(1.0f)));
        if (outputSecondary != null) {
            rec.add(Triple.of((Object)outputSecondary, (Object)1, (Object)Float.valueOf(0.5f)));
        }
        EnderIO.addRecipeIMC("alloying", String.format(FORMAT_STRING, ownerModID, input, output), energy, rec);
    }

    private static void addRecipeIMC(@Nonnull String recipeType, @Nonnull String recipeName, @Nonnull int energy, List<Triple<String, Integer, Float>> recipe) {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document rec = builder.newDocument();
            Element root = rec.createElement("enderio:recipes");
            root.setAttribute("xmlns:enderio", NS_URI);
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xsi:schemaLocation", NS_SCHEMA);
            rec.appendChild(root);
            Element thisRecipe = rec.createElement("recipe");
            Element base = rec.createElement(recipeType);
            thisRecipe.setAttribute("name", recipeName);
            thisRecipe.setAttribute("required", "false");
            base.setAttribute("energy", String.format("%d", energy));
            ArrayList elems = new ArrayList();
            recipe.stream().filter(ing -> ((Float)ing.getRight()).floatValue() == 0.0f).forEach(ing -> {
                Element out = rec.createElement("input");
                out.setAttribute("name", (String)ing.getLeft());
                out.setAttribute("amount", ((Integer)ing.getMiddle()).toString());
                elems.add(out);
            });
            recipe.stream().filter(ing -> ((Float)ing.getRight()).floatValue() > 0.0f).forEach(ing -> {
                Element out = rec.createElement("output");
                if (((Float)ing.getRight()).floatValue() != 1.0f) {
                    out.setAttribute("chance", ((Float)ing.getRight()).toString());
                }
                out.setAttribute("name", (String)ing.getLeft());
                out.setAttribute("amount", ((Integer)ing.getMiddle()).toString());
                elems.add(out);
            });
            elems.stream().forEach(base::appendChild);
            thisRecipe.appendChild(base);
            root.appendChild(thisRecipe);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer tf = factory.newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(root), new StreamResult(out));
            FMLInterModComms.sendMessage((String)PLUGIN_MODID, (String)"recipe:xml", (String)((Object)out).toString());
        }
        catch (ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)"Error building XML for EnderIO IMC");
            report.func_85056_g().func_71507_a("MMDLib Version", (Object)MMDLib.getVersion());
            MMDLib.logger.error(report.func_71502_e());
        }
    }

    protected static void addAlloySmelterAlloy(@Nonnull MMDMaterial material, int energy, @Nonnull String outputItem, @Nonnull int outputQty, @Nonnull Object[] recipe) {
        ArrayList<Triple<String, Integer, Float>> rec = new ArrayList<Triple<String, Integer, Float>>();
        rec.add(Triple.of((Object)outputItem, (Object)outputQty, (Object)Float.valueOf(1.0f)));
        int i = 0;
        while (i < recipe.length) {
            rec.add(Triple.of((Object)((String)recipe[i++]), (Object)((Integer)recipe[i++]), (Object)Float.valueOf(0.0f)));
        }
        String ownerModID = Loader.instance().activeModContainer().getModId();
        String capitalizedName = material.getCapitalizedName();
        EnderIO.addRecipeIMC("alloying", String.format("%s: alloy recipe for %s", ownerModID, capitalizedName), energy, rec);
    }

    protected static void addSagMillRecipe(@Nonnull String materialName) {
        EnderIO.addSagMillRecipe(Materials.getMaterialByName(materialName), null, 2400);
    }

    protected static void addSagMillRecipe(@Nonnull String materialName, @Nonnull int energy) {
        EnderIO.addSagMillRecipe(Materials.getMaterialByName(materialName), null, energy);
    }

    protected static void addSagMillRecipe(@Nonnull String materialName, String outputSecondary, @Nonnull int energy) {
        EnderIO.addSagMillRecipe(Materials.getMaterialByName(materialName), outputSecondary, energy);
    }

    protected static void addSagMillRecipe(@Nonnull MMDMaterial material, @Nullable String outputSecondary, @Nonnull int energy) {
        int primaryQty = 2;
        int secondaryQty = 1;
        if (outputSecondary == null) {
            secondaryQty = 0;
        }
        if (material.getType() == MMDMaterialType.MaterialType.MINERAL) {
            primaryQty = 4;
        }
        EnderIO.addSagMillRecipe(material, primaryQty, outputSecondary, secondaryQty, energy);
    }

    protected static void addSagMillRecipe(@Nonnull String materialName, @Nonnull int primaryQty, @Nonnull String outputSecondary, @Nonnull int secondaryQty, @Nonnull int energy) {
        EnderIO.addSagMillRecipe(Materials.getMaterialByName(materialName), primaryQty, outputSecondary, secondaryQty, energy);
    }

    protected static void addSagMillRecipe(@Nonnull MMDMaterial material, @Nonnull int primaryQty, @Nullable String outputSecondary, @Nonnull int secondaryQty, @Nonnull int energy) {
        String input;
        String ownerModID = Loader.instance().activeModContainer().getModId();
        String capitalizedName = material.getCapitalizedName();
        boolean noSecondary = false;
        if (material.hasOre()) {
            input = "ore" + capitalizedName;
        } else {
            input = "ingot" + capitalizedName;
            noSecondary = true;
        }
        String primaryOutput = "dust" + capitalizedName;
        String secondaryOutput = "dust";
        if (material.getType() == MMDMaterialType.MaterialType.GEM) {
            primaryOutput = "gem" + capitalizedName;
            secondaryOutput = "gem";
        }
        ArrayList<Triple<String, Integer, Float>> rec = new ArrayList<Triple<String, Integer, Float>>();
        rec.add(Triple.of((Object)input, (Object)1, (Object)Float.valueOf(0.0f)));
        if (!noSecondary) {
            rec.add(Triple.of((Object)primaryOutput, (Object)primaryQty, (Object)Float.valueOf(1.0f)));
        } else {
            rec.add(Triple.of((Object)primaryOutput, (Object)1, (Object)Float.valueOf(1.0f)));
        }
        if (outputSecondary != null && !noSecondary) {
            secondaryOutput = secondaryOutput + outputSecondary;
            rec.add(Triple.of((Object)secondaryOutput, (Object)secondaryQty, (Object)Float.valueOf(0.1f)));
        }
        if (!noSecondary) {
            rec.add(Triple.of((Object)"minecraft:cobblestone", (Object)1, (Object)Float.valueOf(0.15f)));
        }
        EnderIO.addRecipeIMC("sagmilling", String.format(FORMAT_STRING, ownerModID, input, primaryOutput), energy, rec);
        if (material.hasOre()) {
            ArrayList<Triple<String, Integer, Float>> rec2 = new ArrayList<Triple<String, Integer, Float>>();
            rec2.add(Triple.of((Object)("ingot" + capitalizedName), (Object)1, (Object)Float.valueOf(0.0f)));
            rec2.add(Triple.of((Object)primaryOutput, (Object)1, (Object)Float.valueOf(1.0f)));
            EnderIO.addRecipeIMC("sagmilling", String.format(FORMAT_STRING, ownerModID, "ingot" + capitalizedName, primaryOutput), energy, rec2);
        }
    }
}

