/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import com.mcmoddev.lib.data.NameToken;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.IntegrationPreInitEvent;
import com.mcmoddev.lib.integration.plugins.thaumcraft.BaseAspectGetter;
import com.mcmoddev.lib.integration.plugins.thaumcraft.IAspectGetter;
import com.mcmoddev.lib.integration.plugins.thaumcraft.TCMaterial;
import com.mcmoddev.lib.integration.plugins.thaumcraft.TCSyncEvent;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class Thaumcraft
implements IIntegration {
    public static final String PLUGIN_MODID = "thaumcraft";
    public static final Thaumcraft INSTANCE = new Thaumcraft();
    private static final IForgeRegistry<TCMaterial> registry = new RegistryBuilder().disableSaving().setMaxID(65535).setName(new ResourceLocation("mmdlib", "thaumcraft_registry")).setType(TCMaterial.class).create();
    private static final Map<String, ResourceLocation> nameToResource = new TreeMap<String, ResourceLocation>();
    private static final Map<NameToken, Float> partMultiplierMap = new HashMap<NameToken, Float>();
    private static boolean initDone = false;

    public static void putPartMultiplier(Names name, Float val) {
        Thaumcraft.putPartMultiplier(name.toString(), val);
    }

    public static void putPartMultiplier(String name, Float val) {
        Thaumcraft.putPartMultiplier(new NameToken(name), val);
    }

    public static void putPartMultiplier(NameToken name, Float val) {
        partMultiplierMap.putIfAbsent(name, val);
    }

    public static float getPartMultiplier(Names name) {
        return Thaumcraft.getPartMultiplier(name.toString());
    }

    public static float getPartMultiplier(String name) {
        return Thaumcraft.getPartMultiplier(new NameToken(name));
    }

    public static float getPartMultiplier(NameToken name) {
        if (partMultiplierMap.containsKey(name)) {
            return partMultiplierMap.get(name).floatValue();
        }
        return 0.0f;
    }

    @Override
    public void init() {
        if (!Config.Options.isModEnabled(PLUGIN_MODID) || initDone) {
            return;
        }
        initDone = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        Thaumcraft.putPartMultiplier(Names.NUGGET, Float.valueOf(1.0f));
        Thaumcraft.putPartMultiplier(Names.INGOT, Float.valueOf(9.0f));
        Thaumcraft.putPartMultiplier(Names.BLOCK, Float.valueOf(Thaumcraft.getPartMultiplier(Names.INGOT) * 9.0f));
        Thaumcraft.putPartMultiplier(Names.ORE, Float.valueOf(Thaumcraft.getPartMultiplier(Names.INGOT)));
        Thaumcraft.putPartMultiplier(Names.GEM, Float.valueOf(Thaumcraft.getPartMultiplier(Names.INGOT)));
        Thaumcraft.putPartMultiplier(Names.BLEND, Float.valueOf(Thaumcraft.getPartMultiplier(Names.INGOT) * 0.8f));
        Thaumcraft.putPartMultiplier(Names.SMALLBLEND, Float.valueOf(Thaumcraft.getPartMultiplier(Names.BLEND) / 9.0f));
        Thaumcraft.putPartMultiplier(Names.POWDER, Float.valueOf(Thaumcraft.getPartMultiplier(Names.BLEND)));
        Thaumcraft.putPartMultiplier(Names.SMALLPOWDER, Float.valueOf(Thaumcraft.getPartMultiplier(Names.SMALLBLEND)));
    }

    @SubscribeEvent
    public void preInitEvents(IntegrationPreInitEvent ev) {
        MinecraftForge.EVENT_BUS.post((Event)new TCSyncEvent(registry, nameToResource));
    }

    @SubscribeEvent
    public void registerAspects(AspectRegistryEvent ev) {
        registry.getValuesCollection().stream().forEach(tcMaterial -> tcMaterial.getAspectMapKeys().forEach(key -> {
            ev.register.registerComplexObjectTag(tcMaterial.getItemStack((NameToken)key), tcMaterial.getAspectFor((NameToken)key));
            ev.register.registerComplexObjectTag(tcMaterial.getBlockItemStack((NameToken)key), tcMaterial.getAspectFor((NameToken)key));
        }));
    }

    public static TCMaterial createVanillaIngotWithAspects(MMDMaterial material) {
        return Thaumcraft.createPartsAspects(material, (IAspectGetter)new BaseAspectGetter(material), Names.NUGGET, Names.BLEND, Names.SMALLBLEND, Names.POWDER, Names.SMALLPOWDER, Names.INGOT);
    }

    public static TCMaterial createVanillaWithAspects(MMDMaterial material) {
        return Thaumcraft.createPartsAspects(material, (IAspectGetter)new BaseAspectGetter(material), Names.NUGGET, Names.BLEND, Names.SMALLBLEND, Names.POWDER, Names.SMALLPOWDER);
    }

    public static TCMaterial createWithAspects(MMDMaterial material) {
        return Thaumcraft.createPartsAspects(material, (IAspectGetter)new BaseAspectGetter(material), Names.values());
    }

    public static TCMaterial createPartsAspects(MMDMaterial material, IAspectGetter aspectGetter, Names ... names) {
        TCMaterial tcMaterial = new TCMaterial(material, aspectGetter);
        for (Names name : names) {
            tcMaterial.getAspectsFor(name);
        }
        return tcMaterial;
    }

    public static TCMaterial createPartsAspects(MMDMaterial material, IAspectGetter aspectGetter, String ... names) {
        TCMaterial tcMaterial = new TCMaterial(material, aspectGetter);
        for (String name : names) {
            tcMaterial.getAspectsFor(name);
        }
        return tcMaterial;
    }
}

