/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.recipe;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Collection;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class RepairRecipeBase
extends ShapelessOreRecipe {
    private static final String ARMOR = "armor";
    private final MMDMaterial material;
    private final ItemStack baseItem;
    private final String materialName;
    private final String itemName;
    private final NonNullList<ItemStack> repairMaterials;

    public RepairRecipeBase(MMDMaterial material, Names itemName) {
        this(material, itemName.toString(), material.getName() + "_" + itemName.toString(), "plate" + material.getCapitalizedName());
    }

    public RepairRecipeBase(MMDMaterial material, Names itemName, Object ... objects) {
        this(material, itemName.toString(), objects);
    }

    public RepairRecipeBase(MMDMaterial material, String itemName, Object ... objects) {
        super(new ResourceLocation(ARMOR), material.getItemStack(itemName), objects);
        this.material = material;
        this.baseItem = material.getItemStack(itemName);
        this.materialName = material.getCapitalizedName();
        this.repairMaterials = OreDictionary.getOres((String)("plate" + this.materialName));
        this.itemName = itemName;
    }

    private boolean repairMaterialsDoesntContain(ItemStack itemStack) {
        return !this.repairMaterials.contains((Object)itemStack);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack item;
        OreDictionary.getOres((String)("plate" + this.materialName)).stream().filter(this::repairMaterialsDoesntContain).forEach(arg_0 -> this.repairMaterials.add(arg_0));
        boolean matched = false;
        boolean repairMatched = false;
        for (int i = 0; i < inv.func_70302_i_() && !(item = inv.func_70301_a(i)).func_190926_b(); ++i) {
            if (!repairMatched) {
                repairMatched = OreDictionary.containsMatch((boolean)false, this.repairMaterials, (ItemStack[])new ItemStack[]{item});
            }
            if (matched) continue;
            matched = this.baseItem.func_77973_b() == item.func_77973_b() && item.func_77952_i() > 0;
        }
        return matched && repairMatched;
    }

    private ItemStack findBaseItem(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack comp;
            ItemStack a = inv.func_70301_a(i);
            if (a == null || !OreDictionary.itemMatches((ItemStack)this.baseItem, (ItemStack)(comp = new ItemStack(a.func_77973_b(), 1, a.func_77960_j())), (boolean)false)) continue;
            return a;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack target = this.findBaseItem(inv);
        if (target.func_190926_b()) {
            return this.material.getItemStack(this.itemName);
        }
        ItemStack rv = new ItemStack(target.func_77973_b(), 1, target.func_77960_j());
        EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)target), (ItemStack)rv);
        rv.func_77964_b(0);
        return rv;
    }

    public int getRecipeSize() {
        int count = 1;
        return count += OreDictionary.getOres((String)("plate" + this.materialName)).size();
    }

    public ItemStack func_77571_b() {
        return this.material.getItemStack(this.itemName);
    }

    public NonNullList<Object> getInput() {
        NonNullList inputs = NonNullList.func_191196_a();
        inputs.add((Object)this.baseItem);
        inputs.addAll((Collection)OreDictionary.getOres((String)("plate" + this.materialName)));
        return inputs;
    }
}

