/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.bloodarsenal;

import arcaratus.bloodarsenal.recipe.SanguineInfusionRecipeRegistry;
import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import moretweaker.Inputs;
import moretweaker.MoreTweaker;
import moretweaker.bloodarsenal.BloodArsenalUtils;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="moretweaker.bloodarsenal.Sanguine")
@ZenRegister
@ModOnly(value="bloodarsenal")
public class Sanguine {
    @ZenProperty
    public static final String BAD_POTION = "bad_potion";
    @ZenProperty
    public static final String BLOOD_LUST = "bloodlust";
    @ZenProperty
    public static final String FLAME = "flame";
    @ZenProperty
    public static final String SHARPNESS = "sharpness";
    @ZenProperty
    public static final String FORTUNATE = "fortunate";
    @ZenProperty
    public static final String LOOTING = "looting";
    @ZenProperty
    public static final String SILKY = "silky";
    @ZenProperty
    public static final String SMELTING = "smelting";
    @ZenProperty
    public static final String EXPERIENCED = "xperienced";
    @ZenProperty
    public static final String BENEFICIAL_POTION = "beneficial_potion";
    @ZenProperty
    public static final String QUICK_DRAW = "quick_draw";
    @ZenProperty
    public static final String SHADOW_TOOL = "shadow_tool";
    @ZenProperty
    public static final String AOD = "aod";
    @ZenProperty
    public static final String SIGIL = "sigil";

    private Sanguine() {
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, final int lpCost, IItemStack catalyst, IIngredient[] inputs) {
        if (inputs.length > 8) {
            CraftTweakerAPI.logError((String)("Sanguine Recipes: 8 Inputs maximum, provided " + inputs.length));
            return;
        }
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final ItemStack c = InputHelper.toStack((IItemStack)catalyst);
        Object[] in = BloodArsenalUtils.toBAArray(Inputs.getObjects(inputs));
        int[] ca = BloodArsenalUtils.amountArray(inputs);
        final Pair[] in2 = new Pair[in.length];
        for (int i = 0; i < in.length; ++i) {
            in2[i] = Pair.of((Object)in[i], (Object)ca[i]);
        }
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SanguineInfusionRecipeRegistry.registerSanguineInfusionRecipe((ItemStack)out, (int)lpCost, (ItemStack)c, (Pair[])in2);
            }

            public String describe() {
                return "Adds a Sanguine-Recipe";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SanguineInfusionRecipeRegistry.getInfusionRecipes().removeIf(r -> !r.isModifier() && Inputs.matchesForRemoval(out, r.getOutput()));
            }

            public String describe() {
                return "Removes Sanguine-Recipes";
            }
        });
    }

    @ZenMethod
    public static void addModifier(final String modifier, final int lpCost, IIngredient[] inputs) {
        if (inputs.length > 8) {
            CraftTweakerAPI.logError((String)("Sanguine Recipes: 8 Inputs maximum, provided " + inputs.length));
            return;
        }
        Object[] in = BloodArsenalUtils.toBAArray(Inputs.getObjects(inputs));
        int[] ca = BloodArsenalUtils.amountArray(inputs);
        final Pair[] in2 = new Pair[in.length];
        for (int i = 0; i < in.length; ++i) {
            in2[i] = Pair.of((Object)in[i], (Object)ca[i]);
        }
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SanguineInfusionRecipeRegistry.registerModificationRecipe((int)lpCost, (String)modifier, (int)1, (Pair[])in2);
            }

            public String describe() {
                return "Adds a Sanguine-Recipe";
            }
        });
    }

    @ZenMethod
    public static void removeModifier(final String modifier) {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SanguineInfusionRecipeRegistry.getInfusionRecipes().removeIf(r -> r.isModifier() && r.getModifierKey().equalsIgnoreCase(modifier));
            }

            public String describe() {
                return "Removes Sanguine-Recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SanguineInfusionRecipeRegistry.getInfusionRecipes().clear();
            }

            public String describe() {
                return "Removes all Sanguine recipes";
            }
        });
    }
}

