/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.erebus;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import erebus.ModItems;
import erebus.recipes.SmoothieMakerRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import moretweaker.Inputs;
import moretweaker.MoreTweaker;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.erebus.SmoothieMaker")
@ZenRegister
@ModOnly(value="erebus")
public class SmoothieMaker {
    private static Field recipeListField = null;

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, ILiquidStack[] fluids) {
        SmoothieMaker.addRecipe(output, InputHelper.toIItemStack((ItemStack)new ItemStack(ModItems.MATERIALS, 1, 59)), inputs, fluids);
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack container, IIngredient[] inputs, ILiquidStack[] fluids) {
        Object[] in;
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final ItemStack c = InputHelper.toStack((IItemStack)container);
        for (Object obj : in = Inputs.getObjects(inputs)) {
            if (obj instanceof ItemStack || obj instanceof String) continue;
            CraftTweakerAPI.logError((String)"For SmoothieMaker.addRecipe: Only IItemSTack and IOreDictEntry are allowed.");
            return;
        }
        final FluidStack[] fl = InputHelper.toFluids((ILiquidStack[])fluids);
        if (in.length > 4 || fl.length > 4) {
            CraftTweakerAPI.logError((String)"For SmoothieMaker.addRecipe: Not more than 4 ingredients and 4 fluids are allowed.");
            return;
        }
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SmoothieMakerRecipe.addRecipe((ItemStack)out, (ItemStack)c, (FluidStack[])fl, (Object[])in);
            }

            public String describe() {
                return "Adds an smoothie maker recipe";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SmoothieMaker.getMutableList().removeIf(r -> Inputs.matchesForRemoval(out, r.getOutput()));
            }

            public String describe() {
                return "Removes some smoothie maker recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                SmoothieMaker.getMutableList().clear();
            }

            public String describe() {
                return "Removes all recipes for the smoothie maker";
            }
        });
    }

    private static ArrayList<SmoothieMakerRecipe> getMutableList() {
        try {
            if (recipeListField == null) {
                recipeListField = SmoothieMakerRecipe.class.getDeclaredField("recipes");
                recipeListField.setAccessible(true);
            }
            return (ArrayList)recipeListField.get(null);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            CraftTweakerAPI.logError((String)("Could not get mutable list for erebus smoothie maker: " + e.getMessage()));
            throw new RuntimeException("Could not get mutable list for erebus smoothie maker: " + e.getMessage(), e);
        }
    }
}

