/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.integration.common.registry;

import cofh.api.util.ThermalExpansionHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import org.icannt.netherendingores.common.registry.BlockData;
import org.icannt.netherendingores.common.registry.RecipeHelper;
import org.icannt.netherendingores.integration.common.data.TiCRecipeData;
import org.icannt.netherendingores.lib.Log;

public class RecipeIntegrationRegistry {
    public static void removeTERecipes() {
        Log.debug("Removing Automatic Thermal Expansion Recipes");
        for (BlockData blockData : BlockData.values()) {
            if (blockData.getRecipeMultiplier() <= 1) continue;
            ThermalExpansionHelper.removeFurnaceRecipe((ItemStack)blockData.getModBlockItemStack());
            ThermalExpansionHelper.removePulverizerRecipe((ItemStack)blockData.getModBlockItemStack());
        }
        Log.info("Removed Automatic Thermal Expansion Recipes");
    }

    public static void registerTiCRecipes() {
        Log.debug("Registering Tinkers' Construct Recipes");
        for (BlockData blockData : BlockData.values()) {
            if (TiCRecipeData.getMilliBuckets(blockData) <= 0 || !FluidRegistry.isFluidRegistered((String)blockData.getRawOreName())) continue;
            RecipeHelper.tryRecipe(blockData, "smeltery", false);
        }
        Log.info("Registered Tinkers' Construct Recipes");
    }

    private static void registerCommonRecipe(String device) {
        RecipeIntegrationRegistry.registerCommonRecipe(device, 1);
    }

    private static void registerCommonRecipe(String device, int multiplier) {
        for (BlockData blockData : BlockData.values()) {
            if (blockData.getRecipeMultiplier() <= multiplier) continue;
            RecipeHelper.tryRecipe(blockData, device, true);
            RecipeHelper.tryRecipe(blockData, device, false);
        }
    }

    public static void registerIERecipes() {
        Log.debug("Registering Immersive Engineering Recipes");
        RecipeIntegrationRegistry.registerCommonRecipe("crusher");
        RecipeIntegrationRegistry.registerCommonRecipe("arcfurn");
        Log.info("Registered Immersive Engineering Recipes");
    }

    public static void registerTERecipes() {
        Log.debug("Registering Thermal Expansion Recipes");
        RecipeIntegrationRegistry.registerCommonRecipe("pulv");
        RecipeIntegrationRegistry.registerCommonRecipe("redfurn");
        RecipeIntegrationRegistry.registerCommonRecipe("indsmeltsand");
        RecipeIntegrationRegistry.registerCommonRecipe("indsmeltrichslag");
        Log.info("Registered Thermal Expansion Recipes");
    }

    public static void registerMekRecipes() {
        Log.debug("Registering Mekanism Recipes");
        RecipeIntegrationRegistry.registerCommonRecipe("enrich", 0);
        Log.info("Registered Mekanism Recipes");
    }

    public static void registerIC2Recipes() {
        Log.debug("Registering Industrial Craft 2 Recipes");
        RecipeIntegrationRegistry.registerCommonRecipe("mace");
        Log.info("Registered Industrial Craft 2 Recipes");
    }
}

