/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IBlockList;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import com.mcmoddev.orespawn.api.os3.OreSpawnBlockMatcher;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FeatureBase
extends IForgeRegistryEntry.Impl<IFeature> {
    private static final int MAX_CACHE_SIZE = 2048;
    private static final Map<Vec3i, Map<BlockPos, IBlockState>> overflowCache = new HashMap<Vec3i, Map<BlockPos, IBlockState>>(2048);
    private static final Deque<Vec3i> cacheOrder = new LinkedList<Vec3i>();
    protected Random random;
    protected static final Vec3i[] offsets_small = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    protected static final Vec3i[] offsets = new Vec3i[]{new Vec3i(-1, -1, -1), new Vec3i(0, -1, -1), new Vec3i(1, -1, -1), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(-1, -1, 0), new Vec3i(0, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1), new Vec3i(1, -1, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    protected static final int[] offsetIndexRef = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    protected static final int[] offsetIndexRef_small = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public FeatureBase(Random rand) {
        this.random = rand;
    }

    public boolean isValidBlock(IBlockState oreBlock) {
        return oreBlock.func_177230_c() != Blocks.field_150350_a;
    }

    protected void runCache(int chunkX, int chunkZ, World world, ISpawnEntry spawnData) {
        Vec3i chunkCoord = new Vec3i(chunkX, chunkZ, world.field_73011_w.getDimension());
        Map<BlockPos, IBlockState> cache = this.retrieveCache(chunkCoord);
        if (!cache.isEmpty()) {
            for (Map.Entry<BlockPos, IBlockState> ent : cache.entrySet()) {
                this.spawnNoCheck(cache.get(ent.getKey()), world, ent.getKey(), world.field_73011_w.getDimension(), spawnData);
            }
        }
    }

    protected boolean spawn(IBlockState oreBlock, World world, BlockPos coord, int dimension, boolean cacheOverflow, ISpawnEntry spawnData) {
        if (oreBlock == null) {
            OreSpawn.LOGGER.fatal("FeatureBase.spawn() called with a null ore!");
            return false;
        }
        if (!this.isValidBlock(oreBlock)) {
            return false;
        }
        Biome thisBiome = world.func_180494_b(coord);
        if (!spawnData.biomeAllowed(thisBiome.getRegistryName())) {
            return false;
        }
        BlockPos np = this.mungeFixYcoord(coord);
        if (coord.func_177956_o() >= world.func_72800_K()) {
            OreSpawn.LOGGER.warn("Asked to spawn {} above build limit at {}", (Object)oreBlock, (Object)coord);
            return false;
        }
        return this.spawnOrCache(world, np, spawnData.getMatcher(), oreBlock, cacheOverflow, dimension, spawnData);
    }

    private BlockPos mungeFixYcoord(BlockPos coord) {
        if (coord.func_177956_o() < 0) {
            int newYCoord = coord.func_177956_o() * -1;
            return new BlockPos(coord.func_177958_n(), newYCoord, coord.func_177952_p());
        }
        return new BlockPos((Vec3i)coord);
    }

    private boolean spawnOrCache(World world, BlockPos coord, OreSpawnBlockMatcher replacer, IBlockState oreBlock, boolean cacheOverflow, int dimension, ISpawnEntry spawnData) {
        if (world.func_175667_e(coord)) {
            int m_x = coord.func_177958_n();
            int p_x = coord.func_177958_n();
            int m_z = coord.func_177952_p();
            int p_z = coord.func_177952_p();
            ChunkPos chunkLoc = world.func_175726_f(coord).func_76632_l();
            ChunkPos endLoc = new ChunkPos(chunkLoc.field_77276_a + 1, chunkLoc.field_77275_b + 1);
            int min_x = chunkLoc.func_180334_c() + 8;
            int max_x = endLoc.func_180334_c() + 8;
            int min_z = chunkLoc.func_180333_d() + 8;
            int max_z = endLoc.func_180333_d() + 8;
            boolean x_bad = false;
            boolean z_bad = false;
            if (m_x < min_x || p_x > max_x) {
                x_bad = true;
            }
            if (m_z < min_z || p_z > max_z) {
                z_bad = true;
            }
            if (x_bad || z_bad) {
                if (cacheOverflow) {
                    this.cacheOverflowBlock(oreBlock, coord, dimension);
                    return true;
                }
                return false;
            }
            if (!this.isValidBlock(oreBlock)) {
                return false;
            }
            IBlockState targetBlock = world.func_180495_p(coord);
            Biome thisBiome = world.func_180494_b(coord);
            if (replacer.test(targetBlock) && spawnData.biomeAllowed(thisBiome.getRegistryName())) {
                world.func_180501_a(coord, oreBlock, 34);
                return true;
            }
            return false;
        }
        if (cacheOverflow) {
            this.cacheOverflowBlock(oreBlock, coord, dimension);
            return true;
        }
        return false;
    }

    private void spawnNoCheck(IBlockState oreBlock, World world, BlockPos coord, int dimension, ISpawnEntry spawnData) {
        if (oreBlock == null) {
            OreSpawn.LOGGER.fatal("FeatureBase.spawn() called with a null ore!");
            return;
        }
        BlockPos np = this.mungeFixYcoord(coord);
        if (coord.func_177956_o() >= world.func_72800_K()) {
            OreSpawn.LOGGER.warn("Asked to spawn {} above build limit at {}", (Object)oreBlock, (Object)coord);
            return;
        }
        this.spawnOrCache(world, np, spawnData.getMatcher(), oreBlock, false, dimension, spawnData);
    }

    private void cacheOverflowBlock(IBlockState bs, BlockPos coord, int dimension) {
        Vec3i chunkCoord = new Vec3i(coord.func_177958_n() / 16, coord.func_177956_o() / 16, dimension);
        if (overflowCache.containsKey(chunkCoord)) {
            cacheOrder.addLast(chunkCoord);
            if (cacheOrder.size() > 2048) {
                Vec3i drop = cacheOrder.removeFirst();
                overflowCache.get(drop).clear();
                overflowCache.remove(drop);
            }
            overflowCache.put(chunkCoord, new HashMap());
        }
        Map cache = overflowCache.getOrDefault(chunkCoord, new HashMap());
        cache.put(coord, bs);
    }

    private Map<BlockPos, IBlockState> retrieveCache(Vec3i chunkCoord) {
        if (overflowCache.containsKey(chunkCoord)) {
            Map<BlockPos, IBlockState> cache = overflowCache.get(chunkCoord);
            cacheOrder.remove(chunkCoord);
            overflowCache.remove(chunkCoord);
            return cache;
        }
        return Collections.emptyMap();
    }

    protected void scramble(int[] target, Random prng) {
        for (int i = target.length - 1; i > 0; --i) {
            int n = prng.nextInt(i);
            int temp = target[i];
            target[i] = target[n];
            target[n] = temp;
        }
    }

    protected static void mergeDefaults(JsonObject parameters, JsonObject defaultParameters) {
        defaultParameters.entrySet().forEach(entry -> {
            if (!parameters.has((String)entry.getKey())) {
                parameters.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        });
    }

    private double triangularDistribution(double a, double b, double c) {
        double base = (c - a) / (b - a);
        double rand = this.random.nextDouble();
        if (rand < base) {
            return a + Math.sqrt(rand * (b - a) * (c - a));
        }
        return b - Math.sqrt((1.0 - rand) * (b - a) * (b - c));
    }

    protected int getPoint(int lowerBound, int upperBound, int median) {
        int t = (int)Math.round(this.triangularDistribution(lowerBound, upperBound, median));
        return t - median;
    }

    protected void spawnMungeInner(Random prng, int rSqr, int quantity, Vec3i vals, ISpawnEntry spawnData, World world, BlockPos blockPos) {
        int dx = vals.func_177958_n();
        int dy = vals.func_177956_o();
        int dz = vals.func_177952_p();
        IBlockList possibleOres = spawnData.getBlocks();
        OreSpawnBlockMatcher replacer = spawnData.getMatcher();
        if (dx * dx + dy * dy + dz * dz <= rSqr) {
            IBlockState oreBlock = possibleOres.getRandomBlock(prng);
            if (oreBlock.func_177230_c().equals(Blocks.field_150350_a)) {
                return;
            }
            this.spawnOrCache(world, blockPos.func_177982_a(dx, dy, dz), replacer, oreBlock, true, world.field_73011_w.getDimension(), spawnData);
            --quantity;
        }
    }

    protected void spawnMungeSW(World world, BlockPos blockPos, int rSqr, double radius, ISpawnEntry spawnData, int count) {
        Random prng = this.random;
        int quantity = count;
        int dy = (int)(-1.0 * radius);
        while ((double)dy < radius) {
            for (int dx = (int)radius; dx >= (int)(-1.0 * radius); --dx) {
                for (int dz = (int)radius; dz >= (int)(-1.0 * radius); --dz) {
                    this.spawnMungeInner(prng, rSqr, quantity, new Vec3i(dx, dy, dz), spawnData, world, blockPos);
                    if (quantity > 0) continue;
                    return;
                }
            }
            ++dy;
        }
    }

    protected void spawnMungeNE(World world, BlockPos blockPos, int rSqr, double radius, ISpawnEntry spawnData, int count) {
        Random prng = this.random;
        int quantity = count;
        int dy = (int)(-1.0 * radius);
        while ((double)dy < radius) {
            int dz = (int)(-1.0 * radius);
            while ((double)dz < radius) {
                int dx = (int)(-1.0 * radius);
                while ((double)dx < radius) {
                    this.spawnMungeInner(prng, rSqr, quantity, new Vec3i(dx, dy, dz), spawnData, world, blockPos);
                    if (quantity <= 0) {
                        return;
                    }
                    ++dx;
                }
                ++dz;
            }
            ++dy;
        }
    }

    protected int getABC(int dx, int dy, int dz) {
        return dx * dx + dy * dy + dz * dz;
    }

    protected int countItem(int dx, boolean toPositive) {
        return toPositive ? dx + 1 : dx - 1;
    }

    protected boolean endCheck(boolean toPositive, int dx, double radius) {
        return toPositive ? dx >= this.getStart(toPositive, radius) : (double)dx < radius;
    }

    protected int getStart(boolean toPositive, double radius) {
        return (int)(radius * (double)(toPositive ? 1 : -1));
    }
}

