/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.json.OreSpawnReader;
import com.mcmoddev.orespawn.json.OreSpawnWriter;
import com.mcmoddev.orespawn.util.StateUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import org.apache.commons.io.FilenameUtils;

public class AddOreCommand
extends CommandBase {
    public String func_71517_b() {
        return "addore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/addore <file> <options - json data>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("Only players can use this command", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null) {
            throw new CommandException("You have no item in your main hand", new Object[0]);
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            throw new CommandException("The item in your main hand isn't a block", new Object[0]);
        }
        if (args.length < 1) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        String file = args[0];
        IBlockState state = Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i());
        String rawData = AddOreCommand.func_147178_a((ICommandSender)sender, (String[])args, (int)1).func_150260_c();
        JsonParser p = new JsonParser();
        JsonElement parsed = rawData != null && rawData.length() > 0 ? this.mergeDefaults(p.parse(rawData), state) : this.mergeDefaults(p.parse("{}"), state);
        OreSpawnReader.loadFromJson(FilenameUtils.getBaseName((String)file), parsed);
        OreSpawnWriter.saveSingle(FilenameUtils.getBaseName((String)file));
    }

    private JsonElement mergeDefaults(JsonElement parse, IBlockState state) {
        JsonObject work = parse.getAsJsonObject();
        JsonObject emptyBlacklist = new JsonObject();
        emptyBlacklist.add("excludes", (JsonElement)new JsonArray());
        if (!work.has("enabled")) {
            work.addProperty("enabled", Boolean.valueOf(true));
        }
        if (!work.has("retrogen")) {
            work.addProperty("retrogen", Boolean.valueOf(false));
        }
        if (!work.has("feature")) {
            work.addProperty("feature", "orespawn:default");
        }
        if (!work.has("replaces")) {
            work.addProperty("replaces", "orespawn:default");
        }
        if (!work.has("parameters")) {
            work.add("parameters", (JsonElement)OreSpawn.API.getFeature(work.get("feature").getAsString()).getDefaultParameters());
        }
        if (!work.has("dimensions")) {
            work.add("dimensions", (JsonElement)emptyBlacklist);
        }
        if (!work.has("biomes")) {
            work.add("biomes", (JsonElement)emptyBlacklist);
        }
        JsonObject block = new JsonObject();
        block.addProperty("chance", (Number)100);
        block.addProperty("name", state.func_177230_c().getRegistryName().toString());
        block.addProperty("state", StateUtil.serializeState(state));
        JsonArray blocks = new JsonArray();
        blocks.add((JsonElement)block);
        work.add("blocks", (JsonElement)blocks);
        return work;
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }
}

