/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft.client;

import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.CraftStudioModelWrapper;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;

public class CSClientModelWrapperVBO
extends CraftStudioModelWrapper {
    public Set<CraftStudioRendererVBO> topRenderers = new HashSet<CraftStudioRendererVBO>();
    protected RenderingObject roDefault;
    protected int glTextureId = -1;
    protected boolean isPrecomputed = false;
    protected static final int nVertices = 30;
    protected static final int sizeStride = 11;
    protected static final int sizeFloat = 4;

    public CSClientModelWrapperVBO(ModelMetadata metadata) {
        super(metadata);
    }

    public void setGlTextureId(int textureId) {
        this.glTextureId = textureId;
    }

    public int getGlTextureId() {
        if (this.glTextureId == -1) {
            this.glTextureId = TextureUtil.func_110996_a();
        }
        return this.glTextureId;
    }

    public void deleteGlTexture() {
        if (this.glTextureId != -1) {
            TextureUtil.func_147942_a((int)this.glTextureId);
            this.glTextureId = -1;
        }
    }

    public void bindGlTexture() {
        GL11.glBindTexture((int)3553, (int)this.getGlTextureId());
    }

    public void addRenderer(CraftStudioRendererVBO renderer) {
        this.topRenderers.add(renderer);
    }

    public void renderPlacement(EntityPlayer player, float timeSinceLastRender, boolean canPlace, int tx, int ty, int tz, int playerOrientation) {
        double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)timeSinceLastRender;
        double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)timeSinceLastRender;
        double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)timeSinceLastRender;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)tx - px + 0.5), (double)((double)ty - py), (double)((double)tz - pz + 0.5));
        GL11.glRotatef((float)((float)playerOrientation * 22.5f), (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        this.startOutlineRendering(3.0f, 1.0f, canPlace ? 1.0f : 0.0f, canPlace ? 1.0f : 0.0f, 0.5f);
        this.renderOutlineVBO(this.roDefault, null, timeSinceLastRender);
        this.stopOutlineRendering();
        GL11.glPopMatrix();
    }

    protected void renderOutline(RenderingObject obj, Object instanceRenderState, float timeSinceLastRender) {
        GL11.glPushMatrix();
        this.startOutlineRendering(1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.renderOutlineVBO(obj, instanceRenderState, timeSinceLastRender);
        this.stopOutlineRendering();
        GL11.glPopMatrix();
    }

    protected void activateTransparency() {
        if (!GLBlendStateManager.saveState()) {
            GL11.glEnable((int)3042);
        }
        GL11.glBlendFunc((int)770, (int)771);
    }

    protected void deactivateTransparency() {
        GLBlendStateManager.restoreState();
    }

    protected void precompute() {
        HashSet<CraftStudioRendererVBO> renderers1st = new HashSet<CraftStudioRendererVBO>();
        HashSet<CraftStudioRendererVBO> renderers2nd = new HashSet<CraftStudioRendererVBO>();
        for (CraftStudioRendererVBO renderer : this.topRenderers) {
            renderer.collectRenderers(renderers1st, renderers2nd);
        }
        this.roDefault = new RenderingObject(this.generateVBOs(renderers1st, renderers2nd), new int[]{renderers1st.size(), renderers2nd.size()}, this.metadata.faceCulling);
        this.isPrecomputed = true;
    }

    public void render(Object instanceRenderState, float timeSinceLastRender, int pass, boolean renderOutline, float rotationAngle, Vector3 rotationVector, Vector3 preRotataionTranslation, Vector3 postRotataionTranslation) {
        if (!this.isPrecomputed) {
            this.precompute();
        }
        GL11.glPushMatrix();
        if (!Vector3.Zero.equals(preRotataionTranslation)) {
            GL11.glTranslatef((float)preRotataionTranslation.x, (float)preRotataionTranslation.y, (float)preRotataionTranslation.z);
        }
        if (!Vector3.Zero.equals(rotationVector)) {
            GL11.glRotatef((float)rotationAngle, (float)rotationVector.x, (float)rotationVector.y, (float)rotationVector.z);
        }
        if (!Vector3.Zero.equals(postRotataionTranslation)) {
            GL11.glTranslatef((float)postRotataionTranslation.x, (float)postRotataionTranslation.y, (float)postRotataionTranslation.z);
        }
        if (CSLibMod.displayOutline && renderOutline) {
            this.renderOutline(this.roDefault, instanceRenderState, timeSinceLastRender);
        }
        this.renderWithVBO(this.roDefault, instanceRenderState, timeSinceLastRender, pass);
        GL11.glPopMatrix();
    }

    public void render(Object instanceRenderState, float timeSinceLastRender, int pass, boolean renderOutline, FloatBuffer transformMatrix) {
        if (!this.isPrecomputed) {
            this.precompute();
        }
        if (transformMatrix != null) {
            GL11.glPushMatrix();
            GL11.glMultMatrix((FloatBuffer)transformMatrix);
        }
        if (CSLibMod.displayOutline && renderOutline) {
            this.renderOutline(this.roDefault, instanceRenderState, timeSinceLastRender);
        }
        this.renderWithVBO(this.roDefault, instanceRenderState, timeSinceLastRender, pass);
        if (transformMatrix != null) {
            GL11.glPopMatrix();
        }
    }

    protected int[] generateVBOs(Set<CraftStudioRendererVBO> nodes1st, Set<CraftStudioRendererVBO> nodes2nd) {
        FloatBuffer qBuffer1st = BufferUtils.createFloatBuffer((int)(330 * nodes1st.size()));
        FloatBuffer qBuffer2nd = BufferUtils.createFloatBuffer((int)(330 * nodes2nd.size()));
        FloatBuffer outlineBuffer = BufferUtils.createFloatBuffer((int)(60 * (nodes1st.size() + nodes2nd.size())));
        for (CraftStudioRendererVBO renderer : nodes1st) {
            renderer.generateVBOTriangleStripInterleaved(qBuffer1st, 0);
            renderer.generateVBOLineStrip(outlineBuffer, 0);
        }
        for (CraftStudioRendererVBO renderer : nodes2nd) {
            renderer.generateVBOTriangleStripInterleaved(qBuffer2nd, 0);
            renderer.generateVBOLineStrip(outlineBuffer, 0);
        }
        qBuffer1st.flip();
        qBuffer2nd.flip();
        outlineBuffer.flip();
        int VBO1st = GL15.glGenBuffers();
        int VBO2nd = GL15.glGenBuffers();
        int VBOOutline = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)VBO1st);
        GL15.glBufferData((int)34962, (FloatBuffer)qBuffer1st, (int)35044);
        GL15.glBindBuffer((int)34962, (int)VBO2nd);
        GL15.glBufferData((int)34962, (FloatBuffer)qBuffer2nd, (int)35044);
        GL15.glBindBuffer((int)34962, (int)VBOOutline);
        GL15.glBufferData((int)34962, (FloatBuffer)outlineBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        return new int[]{VBO1st, VBO2nd, VBOOutline};
    }

    protected void renderWithVBO(RenderingObject obj, Object instanceRenderState, float timeSinceLastRender, int pass) {
        int oldTexture = GL11.glGetInteger((int)32873);
        this.bindGlTexture();
        boolean CULL_FACE = GL11.glIsEnabled((int)2884);
        if (obj.faceCulling) {
            GL11.glEnable((int)2884);
        } else {
            GL11.glDisable((int)2884);
        }
        boolean LIGHT1 = GL11.glIsEnabled((int)16385);
        GL11.glDisable((int)16385);
        boolean ALPHA_TEST = GL11.glIsEnabled((int)3008);
        GL11.glEnable((int)3008);
        int[] vbos = obj.getVBOs();
        int[] sizes = obj.getSizes();
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        GL11.glEnableClientState((int)32886);
        if (pass == 0 || pass == 2) {
            this.drawArrays(vbos[0], sizes[0]);
        }
        if ((pass == 1 || pass == 2) && sizes[1] > 0) {
            this.activateTransparency();
            this.drawArrays(vbos[1], sizes[1]);
            this.deactivateTransparency();
        }
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glDisableClientState((int)32885);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        if (LIGHT1) {
            GL11.glEnable((int)16385);
        }
        if (!CULL_FACE) {
            GL11.glDisable((int)2884);
        }
        if (!ALPHA_TEST) {
            GL11.glDisable((int)3008);
        }
        GL11.glBindTexture((int)3553, (int)oldTexture);
    }

    protected void drawArrays(int vbo, int size) {
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL11.glVertexPointer((int)3, (int)5126, (int)44, (long)0L);
        GL11.glNormalPointer((int)5126, (int)44, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)44, (long)24L);
        GL11.glColorPointer((int)3, (int)5126, (int)44, (long)32L);
        GL11.glDrawArrays((int)5, (int)0, (int)(30 * size));
    }

    protected void renderOutlineVBO(RenderingObject obj, Object instanceRenderState, float timeSinceLastRender) {
        if (obj == null) {
            return;
        }
        GL15.glBindBuffer((int)34962, (int)obj.getVBOOut());
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        for (int i = 0; i < obj.getSizeOut() * 4; ++i) {
            GL11.glDrawArrays((int)3, (int)(i * 5), (int)5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void startOutlineRendering(float width, float r, float g, float b, float a) {
        if (!GLBlendStateManager.saveState()) {
            GL11.glEnable((int)3042);
        }
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnableClientState((int)32884);
        GL11.glLineWidth((float)width);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopOutlineRendering() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glDisableClientState((int)32884);
        GL11.glEnable((int)3553);
        GLBlendStateManager.restoreState();
    }

    private static enum GLBlendStateManager {
        INSTANCE;

        private boolean oldState;
        private boolean savingState = false;
        private int oldSrcRGB;
        private int oldDstRGB;
        private int oldSrcAlpha;
        private int oldDstAlpha;

        static boolean saveState() {
            if (GLBlendStateManager.INSTANCE.savingState) {
                throw new RuntimeException("Already saving blend state!");
            }
            GLBlendStateManager.INSTANCE.savingState = true;
            GLBlendStateManager.INSTANCE.oldState = GL11.glGetBoolean((int)3042);
            GLBlendStateManager.INSTANCE.oldSrcRGB = GL11.glGetInteger((int)32969);
            GLBlendStateManager.INSTANCE.oldDstRGB = GL11.glGetInteger((int)32968);
            GLBlendStateManager.INSTANCE.oldSrcAlpha = GL11.glGetInteger((int)32971);
            GLBlendStateManager.INSTANCE.oldDstAlpha = GL11.glGetInteger((int)32970);
            return GLBlendStateManager.INSTANCE.oldState;
        }

        static void restoreState() {
            if (!GLBlendStateManager.INSTANCE.savingState) {
                throw new RuntimeException("Not saving blend state!");
            }
            GLBlendStateManager.INSTANCE.savingState = false;
            if (!GLBlendStateManager.INSTANCE.oldState) {
                GL11.glDisable((int)3042);
            } else {
                GL14.glBlendFuncSeparate((int)GLBlendStateManager.INSTANCE.oldSrcRGB, (int)GLBlendStateManager.INSTANCE.oldDstRGB, (int)GLBlendStateManager.INSTANCE.oldSrcAlpha, (int)GLBlendStateManager.INSTANCE.oldDstAlpha);
            }
        }
    }

    protected class RenderingObject {
        private final int[][] vbos = new int[16][];
        private final int[][] elems = new int[16][];
        private final boolean faceCulling;

        public RenderingObject(int[] vbos, int[] sizes, boolean faceCulling) {
            this.vbos[0] = vbos;
            this.elems[0] = sizes;
            this.faceCulling = faceCulling;
        }

        public RenderingObject(int[] vbos, int[] sizes, int meta, boolean faceCulling) {
            this.vbos[meta] = vbos;
            this.elems[meta] = sizes;
            this.faceCulling = faceCulling;
        }

        public int[] getVBOs() {
            return this.vbos[0];
        }

        public int getVBO1st() {
            return this.vbos[0][0];
        }

        public int getVBO2nd() {
            return this.vbos[0][1];
        }

        public int getVBOOut() {
            return this.vbos[0][2];
        }

        public int[] getSizes() {
            return this.elems[0];
        }

        public int getSize1st() {
            return this.elems[0][0];
        }

        public int getSize2nd() {
            return this.elems[0][1];
        }

        public int getSizeOut() {
            return this.elems[0][0] + this.elems[0][1];
        }

        public int[] getVBOs(int meta) {
            return this.vbos[meta];
        }

        public int getVBO1st(int meta) {
            return this.vbos[meta][0];
        }

        public int getVBO2nd(int meta) {
            return this.vbos[meta][1];
        }

        public int getVBOOut(int meta) {
            return this.vbos[meta][2];
        }

        public int[] getSizes(int meta) {
            return this.elems[meta];
        }

        public int getSize1st(int meta) {
            return this.elems[meta][0];
        }

        public int getSize2nd(int meta) {
            return this.elems[meta][1];
        }

        public int getSizeOut(int meta) {
            return this.elems[meta][0] + this.elems[meta][1];
        }

        public boolean getFaceCulling() {
            return this.faceCulling;
        }
    }
}

