/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.networking;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import thelm.packagedauto.integration.appeng.networking.HostHelperTile;
import thelm.packagedauto.tile.TileUnpackager;

public class HostHelperTileUnpackager
extends HostHelperTile<TileUnpackager> {
    public HostHelperTileUnpackager(TileUnpackager tile) {
        super(tile);
    }

    public void chargeEnergy() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(((TileUnpackager)this.tile).getEnergyStorage().getMaxReceive(), ((TileUnpackager)this.tile).getEnergyStorage().getMaxEnergyStored() - ((TileUnpackager)this.tile).getEnergyStorage().getEnergyStored());
            double available = energyGrid.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyGrid.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            ((TileUnpackager)this.tile).getEnergyStorage().receiveEnergy(extract, false);
        }
    }

    public void postPatternChange() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this.tile, this.getNode()));
        }
    }
}

