/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.prettybeaches;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.prettybeaches.PrettyBeachesConfig;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FloodingHandler {
    public static final int FLOOD_TIME = 10;
    private static final int MAX_DEPTH = 6;
    private List<Entry> scheduledFloods = new ArrayList<Entry>();

    public void scheduleForFlooding(World world, BlockPos pos, int depth) {
        if (PrettyBeachesConfig.animatedFlooding) {
            this.scheduledFloods.add(new Entry(world, pos, depth));
        } else {
            this.populateWater(world, pos, depth);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (int i = this.scheduledFloods.size() - 1; i >= 0; --i) {
                Entry entry = this.scheduledFloods.get(i);
                ++entry.ticksExisted;
                if (entry.ticksExisted < 10) continue;
                this.populateWater(entry.world, entry.pos, entry.depth);
                this.scheduledFloods.remove(i);
            }
        }
    }

    private void populateWater(World world, BlockPos pos, int depth) {
        IBlockState sourceState = world.func_180495_p(pos);
        if (sourceState.func_177230_c() == Blocks.field_150350_a || sourceState.func_177230_c() == Blocks.field_150358_i || sourceState.func_177230_c() == Blocks.field_150355_j) {
            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 11);
            if (depth <= 6 && pos.func_177956_o() == world.func_181545_F() - 1) {
                BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
                for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                    int waterLevel;
                    mutPos.func_189533_g((Vec3i)pos).func_189536_c(facing);
                    IBlockState state = world.func_180495_p((BlockPos)mutPos);
                    int n = waterLevel = state.func_177230_c() == Blocks.field_150358_i ? (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) : -1;
                    if (state.func_177230_c() != Blocks.field_150350_a && (waterLevel <= 0 || waterLevel >= 11)) continue;
                    this.scheduleForFlooding(world, (BlockPos)mutPos, depth + 1);
                    return;
                }
            }
        }
    }

    public class Entry {
        public World world;
        public BlockPos pos;
        public int depth;
        public int ticksExisted;

        public Entry(World world, BlockPos pos, int depth) {
            this.world = world;
            this.pos = pos;
            this.depth = depth;
        }
    }
}

