/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class PIPartRenderer {
    public StyleHandler.PropertyGroup props;
    private boolean[] sides = new boolean[]{true, true, true, true};
    private boolean squareTex = true;
    private int tabRender = 0;
    private boolean buttonRender = false;

    public PIPartRenderer(StyleHandler.PropertyGroup props) {
        this.props = props;
    }

    public PIPartRenderer setSideTrims(boolean top, boolean left, boolean bottom, boolean right) {
        this.sides = new boolean[]{top, left, bottom, right};
        return this;
    }

    public PIPartRenderer setSquareTex(boolean squareTex) {
        this.squareTex = squareTex;
        return this;
    }

    public PIPartRenderer setButtonRender(boolean buttonRender) {
        this.buttonRender = buttonRender;
        return this;
    }

    public PIPartRenderer setTabRender(int tabRender) {
        this.tabRender = tabRender;
        return this;
    }

    public void render(MGuiElementBase parent, boolean mouseOver) {
        this.render(parent, parent.xPos(), parent.yPos(), parent.xSize(), parent.ySize(), mouseOver);
    }

    public void render(MGuiElementBase parent) {
        this.render(parent, parent.xPos(), parent.yPos(), parent.xSize(), parent.ySize(), false);
    }

    public void render(MGuiElementBase parent, int x, int y, int width, int height) {
        this.render(parent, x, y, width, height, false);
    }

    public void render(MGuiElementBase parent, int x, int y, int width, int height, boolean mouseOver) {
        int border;
        boolean vanillaTex = this.props.hasPropVanillaTex() && this.props.vanillaTex();
        boolean thickBorders = this.props.hasPropThickBorders() && this.props.thickBorders();
        int colour = this.props.hasPropColourHover() && mouseOver ? this.props.colourHover() : this.props.colour();
        int n = border = this.props.hasPropBorderHover() && mouseOver ? this.props.borderHover() : this.props.border();
        if (vanillaTex) {
            if (this.props.hasPropColourHover() && mouseOver) {
                this.props.glColourHover();
            } else {
                this.props.glColour();
            }
            if (this.buttonRender) {
                int texV = 48 + (mouseOver ? 2 : 1) * 20;
                ResourceHelperBC.bindTexture((ResourceLocation)PITextures.PI_PARTS);
                parent.drawTiledTextureRectWithTrim(x, y, width, height, 2, 2, 2, 2, 0, texV, 200, 20);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                parent.drawBorderedRect((double)x, (double)y, (double)width, (double)height, 1.0, 0, border);
            } else {
                ResourceHelperBC.bindTexture((ResourceLocation)(this.squareTex ? PITextures.VANILLA_GUI_SQ : PITextures.VANILLA_GUI));
                int texU = this.left() ? 0 : 4;
                int texV = (thickBorders ? 0 : 128) + (this.top() ? 0 : 4);
                int texW = 256 - (this.left() ? 0 : 4) - (this.right() ? 0 : 4);
                int texH = 128 - (this.top() ? 0 : 4) - (this.bottom() ? 0 : 4);
                this.drawTiledTextureRectWithTrim(parent, x, y, width, height, this.top() ? 4 : 0, this.left() ? 4 : 0, this.bottom() ? 4 : 0, this.right() ? 4 : 0, texU, texV, texW, texH);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.squareTex) {
                    this.drawShadedRect(parent, x, y, width, height, 1, 0, border, border, border);
                }
                if (this.tabRender > 0) {
                    parent.drawTiledTextureRectWithTrim(x + 1, y + height - 1, width - 2, this.tabRender + 1, 0, 4, 0, 4, texU + 1, texV + 4, texW - 2, texH - 8);
                }
            }
        } else {
            int bw;
            boolean shadedBorders = this.props.hasPropShadeBorders() && this.props.shadeBorders();
            boolean invertShade = this.props.hasPropInvertShade() && this.props.invertShade();
            int n2 = bw = thickBorders ? 2 : 1;
            if (shadedBorders) {
                int light = parent.changeShade(border, 0.2);
                int dark = parent.changeShade(border, -0.2);
                this.drawShadedRect(parent, x, y, width, height, bw, colour, invertShade ? dark : light, invertShade ? light : dark, border);
                if (this.tabRender > 0) {
                    parent.drawColouredRect((double)(x + bw), (double)(y + height), (double)(width - bw * 2), (double)this.tabRender, colour);
                    parent.drawColouredRect((double)(x + width - bw), (double)(y + height), (double)bw, (double)bw, invertShade ? light : dark);
                }
            } else {
                this.drawShadedRect(parent, x, y, width, height, bw, colour, border, border, border);
                if (this.tabRender > 0) {
                    parent.drawColouredRect((double)(x + bw), (double)(y + height), (double)(width - bw * 2), (double)this.tabRender, colour);
                }
            }
        }
    }

    public void drawShadedRect(MGuiElementBase element, int x, int y, int width, int height, int bw, int fill, int topLeftColour, int bottomRightColour, int cornerMixColour) {
        element.drawColouredRect((double)(x + (this.left() ? bw : 0)), (double)(y + (this.top() ? bw : 0)), (double)(width - (this.left() ? bw : 0) - (this.right() ? bw : 0)), (double)(height - (this.top() ? bw : 0) - (this.bottom() ? bw : 0)), fill);
        if (this.top()) {
            element.drawColouredRect((double)x, (double)y, (double)(width - (this.right() ? bw : 0)), (double)bw, topLeftColour);
        }
        if (this.left()) {
            element.drawColouredRect((double)x, (double)(y + (this.top() ? bw : 0)), (double)bw, (double)(height - (this.top() ? bw : 0) - (this.bottom() ? bw : 0)), topLeftColour);
        }
        if (this.bottom()) {
            element.drawColouredRect((double)(x + (this.left() ? bw : 0)), (double)(y + height - bw), (double)(width - (this.left() ? bw : 0)), (double)bw, bottomRightColour);
        }
        if (this.right()) {
            element.drawColouredRect((double)(x + width - bw), (double)(y + (this.top() ? bw : 0)), (double)bw, (double)(height - (this.top() ? bw : 0) - (this.bottom() ? bw : 0)), bottomRightColour);
        }
        if (this.top() && this.right()) {
            element.drawColouredRect((double)(x + width - bw), (double)y, (double)bw, (double)bw, cornerMixColour);
        }
        if (this.bottom() && this.left()) {
            element.drawColouredRect((double)x, (double)(y + height - bw), (double)bw, (double)bw, cornerMixColour);
        }
    }

    private void drawTiledTextureRectWithTrim(MGuiElementBase element, int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int texU, int texV, int texWidth, int texHeight) {
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = x == 0 ? texU : (x + trimWidth <= xSize ? texU + leftTrim : texU + (texWidth - (xSize - x)));
            this.bufferTexturedModalRect(element, buffer, xPos + x, yPos, trimU, texV, rWidth, topTrim);
            this.bufferTexturedModalRect(element, buffer, xPos + x, yPos + ySize - bottomTrim, trimU, texV + texHeight - bottomTrim, rWidth, bottomTrim);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int trimV = y + texHeight <= ySize ? texV + topTrim : texV + (texHeight - (ySize - y));
                if (x == 0) {
                    this.bufferTexturedModalRect(element, buffer, xPos, yPos + y + topTrim, texU, trimV, leftTrim, rHeight);
                    this.bufferTexturedModalRect(element, buffer, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight);
                }
                this.bufferTexturedModalRect(element, buffer, xPos + x + leftTrim, yPos + y + topTrim, texU + leftTrim, texV + topTrim, rWidth, rHeight);
            }
        }
        tessellator.func_78381_a();
    }

    private void bufferTexturedModalRect(MGuiElementBase element, BufferBuilder buffer, int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = element.getRenderZLevel();
        buffer.func_181662_b((double)x, (double)(y + height), zLevel).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, zLevel).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
    }

    private boolean top() {
        return this.sides[0];
    }

    private boolean left() {
        return this.sides[1];
    }

    private boolean bottom() {
        return this.sides[2];
    }

    private boolean right() {
        return this.sides[3];
    }

    public StyledElement asElement() {
        return new StyledElement(this);
    }

    public static class StyledElement
    extends MGuiElementBase<StyledElement> {
        private Supplier<Boolean> hoverStateSupplier = null;
        private PIPartRenderer renderer;

        public StyledElement(PIPartRenderer renderer) {
            this.renderer = renderer;
        }

        public StyledElement setHoverStateSupplier(Supplier<Boolean> hoverStateSupplier) {
            this.hoverStateSupplier = hoverStateSupplier;
            return this;
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.renderer.render(this, this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.isMouseOver(mouseX, mouseY) || this.hoverStateSupplier != null && this.hoverStateSupplier.get() != false);
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

