/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.models.blocks;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lumien.randomthings.block.BlockInventoryRerouter;
import lumien.randomthings.lib.AtlasSprite;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelInventoryRerouter
implements IBakedModel {
    Cache<CacheEntry, HashMap<EnumFacing, List<BakedQuad>>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(120L, TimeUnit.SECONDS).build();
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/side")
    public static TextureAtlasSprite interfaceBase;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/side_con")
    public static TextureAtlasSprite interfaceCon;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/overlay_down")
    public static TextureAtlasSprite overlay_down;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/overlay_up")
    public static TextureAtlasSprite overlay_up;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/overlay_north")
    public static TextureAtlasSprite overlay_north;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/overlay_south")
    public static TextureAtlasSprite overlay_south;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/overlay_west")
    public static TextureAtlasSprite overlay_west;
    @AtlasSprite(resource="randomthings:blocks/inventoryrerouter/overlay_east")
    public static TextureAtlasSprite overlay_east;
    ArrayList<BakedQuad> emptyList = new ArrayList();
    static final float part = 0.0625f;

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null || state == null) {
            return this.emptyList;
        }
        HashMap overrideData = (HashMap)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockInventoryRerouter.OVERRIDE_DATA);
        if (overrideData == null) {
            return this.emptyList;
        }
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)BlockInventoryRerouter.FACING);
        CacheEntry entry = new CacheEntry(overrideData, blockFacing);
        HashMap quadMap = (HashMap)this.modelCache.getIfPresent((Object)entry);
        if (quadMap != null) {
            return (List)quadMap.get(side);
        }
        quadMap = new HashMap();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BakedQuad baseQuad;
            ArrayList<BakedQuad> quadList = new ArrayList<BakedQuad>();
            quadMap.put(facing, quadList);
            if (facing == blockFacing) {
                baseQuad = this.createSidedBakedQuad(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 16.0f, 16.0f, -1, interfaceCon, facing);
                quadList.add(baseQuad);
                continue;
            }
            baseQuad = this.createSidedBakedQuad(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 16.0f, 16.0f, -1, interfaceBase, facing);
            quadList.add(baseQuad);
            EnumFacing override = (EnumFacing)overrideData.get(facing);
            if (override == null) continue;
            TextureAtlasSprite overlaySprite = null;
            if (override == EnumFacing.DOWN) {
                overlaySprite = overlay_down;
            } else if (override == EnumFacing.UP) {
                overlaySprite = overlay_up;
            } else if (override == EnumFacing.NORTH) {
                overlaySprite = overlay_north;
            } else if (override == EnumFacing.SOUTH) {
                overlaySprite = overlay_south;
            } else if (override == EnumFacing.WEST) {
                overlaySprite = overlay_west;
            } else if (override == EnumFacing.EAST) {
                overlaySprite = overlay_east;
            }
            if (overlaySprite == null) continue;
            BakedQuad overrideQuad = this.createSidedBakedQuad(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 16.0f, 16.0f, -1, overlaySprite, facing);
            quadList.add(overrideQuad);
        }
        this.modelCache.put((Object)new CacheEntry(overrideData, blockFacing), quadMap);
        return (List)quadMap.get(side);
    }

    private BakedQuad createSidedBakedQuad(float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side) {
        Vec3d v1 = ModelInventoryRerouter.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v2 = ModelInventoryRerouter.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v3 = ModelInventoryRerouter.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v4 = ModelInventoryRerouter.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c, -1, texture, 0.0f, 0.0f, side), this.vertexToInts((float)v2.field_72450_a, (float)v2.field_72448_b, (float)v2.field_72449_c, -1, texture, 0.0f, 16.0f, side), this.vertexToInts((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c, -1, texture, 16.0f, 16.0f, side), this.vertexToInts((float)v4.field_72450_a, (float)v4.field_72448_b, (float)v4.field_72449_c, -1, texture, 16.0f, 0.0f, side)}), -1, side, texture, false, DefaultVertexFormats.field_176599_b);
    }

    private BakedQuad createSidedBakedQuad(float x1, float x2, float z1, float z2, float y, float u1, float v1, float u2, float v2, int tintIndex, TextureAtlasSprite texture, EnumFacing side) {
        Vec3d c1 = ModelInventoryRerouter.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c2 = ModelInventoryRerouter.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c3 = ModelInventoryRerouter.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c4 = ModelInventoryRerouter.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        EnumFacing rotation = EnumFacing.SOUTH;
        if (side == EnumFacing.WEST || side == EnumFacing.EAST || side == EnumFacing.SOUTH) {
            rotation = EnumFacing.SOUTH;
        } else if (side == EnumFacing.NORTH) {
            rotation = EnumFacing.WEST;
            c1 = ModelInventoryRerouter.rotate(c1.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c2 = ModelInventoryRerouter.rotate(c2.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c3 = ModelInventoryRerouter.rotate(c3.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c4 = ModelInventoryRerouter.rotate(c4.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
        }
        if (side != EnumFacing.UP && side != EnumFacing.SOUTH && side != EnumFacing.DOWN) {
            c1 = ModelInventoryRerouter.rotate(c1.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c2 = ModelInventoryRerouter.rotate(c2.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c3 = ModelInventoryRerouter.rotate(c3.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c4 = ModelInventoryRerouter.rotate(c4.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
        }
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts((float)c1.field_72450_a, (float)c1.field_72448_b, (float)c1.field_72449_c, -1, texture, u1, v1, side), this.vertexToInts((float)c2.field_72450_a, (float)c2.field_72448_b, (float)c2.field_72449_c, -1, texture, u1, v2, side), this.vertexToInts((float)c3.field_72450_a, (float)c3.field_72448_b, (float)c3.field_72449_c, -1, texture, u2, v2, side), this.vertexToInts((float)c4.field_72450_a, (float)c4.field_72448_b, (float)c4.field_72449_c, -1, texture, u2, v1, side)}), tintIndex, side, texture, false, DefaultVertexFormats.field_176599_b);
    }

    private static Vec3d rotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }

    private int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, EnumFacing side) {
        int xN = (byte)(side.func_82601_c() * 127) & 0xFF;
        int yN = (byte)(side.func_96559_d() * 127) & 0xFF;
        int zN = (byte)(side.func_82599_e() * 127) & 0xFF;
        int normal = xN | yN << 8 | zN << 16;
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), normal};
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return interfaceBase;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private class CacheEntry {
        HashMap<EnumFacing, EnumFacing> overrideData;
        EnumFacing facing;

        public CacheEntry(HashMap<EnumFacing, EnumFacing> overrideData, EnumFacing facing) {
            this.overrideData = overrideData;
            this.facing = facing;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.facing == null ? 0 : this.facing.hashCode());
            result = 31 * result + (this.overrideData == null ? 0 : this.overrideData.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.facing != other.facing) {
                return false;
            }
            return !(this.overrideData == null ? other.overrideData != null : !this.overrideData.equals(other.overrideData));
        }

        private ModelInventoryRerouter getOuterType() {
            return ModelInventoryRerouter.this;
        }
    }
}

