/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.util;

import com.github.lunatrius.core.util.math.BlockPosHelper;
import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.block.state.BlockStateHelper;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.storage.Schematic;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class RotationHelper {
    public static final RotationHelper INSTANCE = new RotationHelper();
    private static final EnumFacing[][] FACINGS = new EnumFacing[EnumFacing.field_82609_l.length][];
    private static final EnumFacing.Axis[][] AXISES = new EnumFacing.Axis[EnumFacing.Axis.values().length][];
    private static final BlockLog.EnumAxis[][] AXISES_LOG = new BlockLog.EnumAxis[EnumFacing.Axis.values().length][];
    private static final BlockQuartz.EnumType[][] AXISES_QUARTZ = new BlockQuartz.EnumType[EnumFacing.Axis.values().length][];

    public boolean rotate(SchematicWorld world, EnumFacing axis, boolean forced) {
        if (world == null) {
            return false;
        }
        try {
            ISchematic schematic = world.getSchematic();
            Schematic schematicRotated = this.rotate(schematic, axis, forced);
            this.updatePosition(world, axis);
            world.setSchematic(schematicRotated);
            for (TileEntity tileEntity : world.getTileEntities()) {
                world.initializeTileEntity(tileEntity);
            }
            return true;
        }
        catch (RotationException re) {
            Reference.logger.error(re.getMessage());
        }
        catch (Exception e) {
            Reference.logger.fatal("Something went wrong!", (Throwable)e);
        }
        return false;
    }

    private void updatePosition(SchematicWorld world, EnumFacing axis) {
        switch (axis) {
            case DOWN: 
            case UP: {
                int offset = (world.getWidth() - world.getLength()) / 2;
                world.position.field_177962_a += offset;
                world.position.field_177961_c -= offset;
                break;
            }
            case NORTH: 
            case SOUTH: {
                int offset = (world.getWidth() - world.func_72800_K()) / 2;
                world.position.field_177962_a += offset;
                world.position.field_177960_b -= offset;
                break;
            }
            case WEST: 
            case EAST: {
                int offset = (world.func_72800_K() - world.getLength()) / 2;
                world.position.field_177960_b += offset;
                world.position.field_177961_c -= offset;
                break;
            }
        }
    }

    public Schematic rotate(ISchematic schematic, EnumFacing axis, boolean forced) throws RotationException {
        Vec3i dimensionsRotated = this.rotateDimensions(axis, schematic.getWidth(), schematic.getHeight(), schematic.getLength());
        Schematic schematicRotated = new Schematic(schematic.getIcon(), dimensionsRotated.func_177958_n(), dimensionsRotated.func_177956_o(), dimensionsRotated.func_177952_p(), schematic.getAuthor());
        MBlockPos tmp = new MBlockPos();
        for (MBlockPos pos : BlockPosHelper.getAllInBox((int)0, (int)0, (int)0, (int)(schematic.getWidth() - 1), (int)(schematic.getHeight() - 1), (int)(schematic.getLength() - 1))) {
            IBlockState blockState = schematic.getBlockState((BlockPos)pos);
            IBlockState blockStateRotated = this.rotateBlock(blockState, axis, forced);
            schematicRotated.setBlockState(this.rotatePos((BlockPos)pos, axis, dimensionsRotated, tmp), blockStateRotated);
        }
        List<TileEntity> tileEntities = schematic.getTileEntities();
        for (TileEntity tileEntity : tileEntities) {
            BlockPos pos = tileEntity.func_174877_v();
            tileEntity.func_174878_a(new BlockPos((Vec3i)this.rotatePos(pos, axis, dimensionsRotated, tmp)));
            schematicRotated.setTileEntity(tileEntity.func_174877_v(), tileEntity);
        }
        return schematicRotated;
    }

    private Vec3i rotateDimensions(EnumFacing axis, int width, int height, int length) throws RotationException {
        switch (axis) {
            case DOWN: 
            case UP: {
                return new Vec3i(length, height, width);
            }
            case NORTH: 
            case SOUTH: {
                return new Vec3i(height, width, length);
            }
            case WEST: 
            case EAST: {
                return new Vec3i(width, length, height);
            }
        }
        throw new RotationException("'%s' is not a valid axis!", axis.func_176610_l());
    }

    private BlockPos rotatePos(BlockPos pos, EnumFacing axis, Vec3i dimensions, MBlockPos rotated) throws RotationException {
        switch (axis) {
            case DOWN: {
                return rotated.set(pos.func_177952_p(), pos.func_177956_o(), dimensions.func_177952_p() - 1 - pos.func_177958_n());
            }
            case UP: {
                return rotated.set(dimensions.func_177958_n() - 1 - pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case NORTH: {
                return rotated.set(dimensions.func_177958_n() - 1 - pos.func_177956_o(), pos.func_177958_n(), pos.func_177952_p());
            }
            case SOUTH: {
                return rotated.set(pos.func_177956_o(), dimensions.func_177956_o() - 1 - pos.func_177958_n(), pos.func_177952_p());
            }
            case WEST: {
                return rotated.set(pos.func_177958_n(), dimensions.func_177956_o() - 1 - pos.func_177952_p(), pos.func_177956_o());
            }
            case EAST: {
                return rotated.set(pos.func_177958_n(), pos.func_177952_p(), dimensions.func_177952_p() - 1 - pos.func_177956_o());
            }
        }
        throw new RotationException("'%s' is not a valid axis!", axis.func_176610_l());
    }

    private IBlockState rotateBlock(IBlockState blockState, EnumFacing axisRotation, boolean forced) throws RotationException {
        IProperty propertyVariant;
        IProperty propertyAxis;
        IProperty propertyFacing = BlockStateHelper.getProperty(blockState, "facing");
        if (propertyFacing instanceof PropertyDirection) {
            Comparable value = blockState.func_177229_b(propertyFacing);
            if (value instanceof EnumFacing) {
                EnumFacing facing = RotationHelper.getRotatedFacing(axisRotation, (EnumFacing)value);
                if (propertyFacing.func_177700_c().contains(facing)) {
                    return blockState.func_177226_a(propertyFacing, (Comparable)facing);
                }
            }
        } else if (propertyFacing instanceof PropertyEnum) {
            if (BlockLever.EnumOrientation.class.isAssignableFrom(propertyFacing.func_177699_b())) {
                BlockLever.EnumOrientation orientation = (BlockLever.EnumOrientation)blockState.func_177229_b(propertyFacing);
                BlockLever.EnumOrientation orientationRotated = RotationHelper.getRotatedLeverFacing(axisRotation, orientation);
                if (propertyFacing.func_177700_c().contains(orientationRotated)) {
                    return blockState.func_177226_a(propertyFacing, (Comparable)orientationRotated);
                }
            }
        } else if (propertyFacing != null) {
            Reference.logger.error("'{}': found 'facing' property with unknown type {}", Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c()), (Object)propertyFacing.getClass().getSimpleName());
        }
        if ((propertyAxis = BlockStateHelper.getProperty(blockState, "axis")) instanceof PropertyEnum) {
            EnumFacing.Axis axis;
            if (EnumFacing.Axis.class.isAssignableFrom(propertyAxis.func_177699_b())) {
                axis = (EnumFacing.Axis)blockState.func_177229_b(propertyAxis);
                EnumFacing.Axis axisRotated = RotationHelper.getRotatedAxis(axisRotation, axis);
                return blockState.func_177226_a(propertyAxis, (Comparable)axisRotated);
            }
            if (BlockLog.EnumAxis.class.isAssignableFrom(propertyAxis.func_177699_b())) {
                axis = (BlockLog.EnumAxis)blockState.func_177229_b(propertyAxis);
                BlockLog.EnumAxis axisRotated = RotationHelper.getRotatedLogAxis(axisRotation, (BlockLog.EnumAxis)axis);
                return blockState.func_177226_a(propertyAxis, (Comparable)axisRotated);
            }
        } else if (propertyAxis != null) {
            Reference.logger.error("'{}': found 'axis' property with unknown type {}", Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c()), (Object)propertyAxis.getClass().getSimpleName());
        }
        if ((propertyVariant = BlockStateHelper.getProperty(blockState, "variant")) instanceof PropertyEnum && BlockQuartz.EnumType.class.isAssignableFrom(propertyVariant.func_177699_b())) {
            BlockQuartz.EnumType type = (BlockQuartz.EnumType)blockState.func_177229_b(propertyVariant);
            BlockQuartz.EnumType typeRotated = RotationHelper.getRotatedQuartzType(axisRotation, type);
            return blockState.func_177226_a(propertyVariant, (Comparable)typeRotated);
        }
        if (!(forced || propertyFacing == null && propertyAxis == null)) {
            throw new RotationException("'%s' cannot be rotated around '%s'", Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c()), axisRotation);
        }
        return blockState;
    }

    private static EnumFacing getRotatedFacing(EnumFacing source, EnumFacing side) {
        return FACINGS[source.ordinal()][side.ordinal()];
    }

    private static EnumFacing.Axis getRotatedAxis(EnumFacing source, EnumFacing.Axis axis) {
        return AXISES[source.func_176740_k().ordinal()][axis.ordinal()];
    }

    private static BlockLog.EnumAxis getRotatedLogAxis(EnumFacing source, BlockLog.EnumAxis axis) {
        return AXISES_LOG[source.func_176740_k().ordinal()][axis.ordinal()];
    }

    private static BlockQuartz.EnumType getRotatedQuartzType(EnumFacing source, BlockQuartz.EnumType type) {
        return AXISES_QUARTZ[source.func_176740_k().ordinal()][type.ordinal()];
    }

    private static BlockLever.EnumOrientation getRotatedLeverFacing(EnumFacing source, BlockLever.EnumOrientation side) {
        EnumFacing facing = source.func_176740_k().func_176720_b() && side.func_176852_c().func_176740_k().func_176720_b() ? (side == BlockLever.EnumOrientation.UP_X || side == BlockLever.EnumOrientation.DOWN_X ? EnumFacing.NORTH : EnumFacing.WEST) : side.func_176852_c();
        EnumFacing facingRotated = RotationHelper.getRotatedFacing(source, side.func_176852_c());
        return BlockLever.EnumOrientation.func_176856_a((EnumFacing)facingRotated, (EnumFacing)facing);
    }

    static {
        RotationHelper.FACINGS[EnumFacing.DOWN.ordinal()] = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH};
        RotationHelper.FACINGS[EnumFacing.UP.ordinal()] = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
        RotationHelper.FACINGS[EnumFacing.NORTH.ordinal()] = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.UP};
        RotationHelper.FACINGS[EnumFacing.SOUTH.ordinal()] = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.DOWN};
        RotationHelper.FACINGS[EnumFacing.WEST.ordinal()] = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST};
        RotationHelper.FACINGS[EnumFacing.EAST.ordinal()] = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST};
        RotationHelper.AXISES[EnumFacing.Axis.X.ordinal()] = new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z, EnumFacing.Axis.Y};
        RotationHelper.AXISES[EnumFacing.Axis.Y.ordinal()] = new EnumFacing.Axis[]{EnumFacing.Axis.Z, EnumFacing.Axis.Y, EnumFacing.Axis.X};
        RotationHelper.AXISES[EnumFacing.Axis.Z.ordinal()] = new EnumFacing.Axis[]{EnumFacing.Axis.Y, EnumFacing.Axis.X, EnumFacing.Axis.Z};
        RotationHelper.AXISES_LOG[EnumFacing.Axis.X.ordinal()] = new BlockLog.EnumAxis[]{BlockLog.EnumAxis.X, BlockLog.EnumAxis.Z, BlockLog.EnumAxis.Y, BlockLog.EnumAxis.NONE};
        RotationHelper.AXISES_LOG[EnumFacing.Axis.Y.ordinal()] = new BlockLog.EnumAxis[]{BlockLog.EnumAxis.Z, BlockLog.EnumAxis.Y, BlockLog.EnumAxis.X, BlockLog.EnumAxis.NONE};
        RotationHelper.AXISES_LOG[EnumFacing.Axis.Z.ordinal()] = new BlockLog.EnumAxis[]{BlockLog.EnumAxis.Y, BlockLog.EnumAxis.X, BlockLog.EnumAxis.Z, BlockLog.EnumAxis.NONE};
        RotationHelper.AXISES_QUARTZ[EnumFacing.Axis.X.ordinal()] = new BlockQuartz.EnumType[]{BlockQuartz.EnumType.DEFAULT, BlockQuartz.EnumType.CHISELED, BlockQuartz.EnumType.LINES_Z, BlockQuartz.EnumType.LINES_X, BlockQuartz.EnumType.LINES_Y};
        RotationHelper.AXISES_QUARTZ[EnumFacing.Axis.Y.ordinal()] = new BlockQuartz.EnumType[]{BlockQuartz.EnumType.DEFAULT, BlockQuartz.EnumType.CHISELED, BlockQuartz.EnumType.LINES_Y, BlockQuartz.EnumType.LINES_Z, BlockQuartz.EnumType.LINES_X};
        RotationHelper.AXISES_QUARTZ[EnumFacing.Axis.Z.ordinal()] = new BlockQuartz.EnumType[]{BlockQuartz.EnumType.DEFAULT, BlockQuartz.EnumType.CHISELED, BlockQuartz.EnumType.LINES_X, BlockQuartz.EnumType.LINES_Y, BlockQuartz.EnumType.LINES_Z};
    }

    public static class RotationException
    extends Exception {
        public RotationException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }
}

