/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.world.chunk;

import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.client.world.chunk.ChunkSchematic;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;

@MethodsReturnNonnullByDefault
public class ChunkProviderSchematic
extends ChunkProviderClient
implements IChunkProvider {
    private final SchematicWorld world;
    private final Chunk emptyChunk;
    private final Map<Long, ChunkSchematic> chunks = new ConcurrentHashMap<Long, ChunkSchematic>();

    public ChunkProviderSchematic(SchematicWorld world) {
        super((World)world);
        this.world = world;
        this.emptyChunk = new EmptyChunk((World)world, 0, 0){

            public boolean func_76621_g() {
                return false;
            }
        };
    }

    private boolean chunkExists(int x, int z) {
        return x >= 0 && z >= 0 && x < this.world.getWidth() && z < this.world.getLength();
    }

    public Chunk func_186026_b(int x, int z) {
        if (!this.chunkExists(x, z)) {
            return this.emptyChunk;
        }
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        ChunkSchematic chunk = this.chunks.get(key);
        if (chunk == null) {
            chunk = new ChunkSchematic((World)this.world, x, z);
            this.chunks.put(key, chunk);
        }
        return chunk;
    }

    public Chunk func_186025_d(int x, int z) {
        return this.func_186026_b(x, z);
    }

    public String func_73148_d() {
        return "SchematicChunkCache";
    }

    public Chunk func_73158_c(int x, int z) {
        return (Chunk)MoreObjects.firstNonNull((Object)this.func_186026_b(x, z), (Object)this.emptyChunk);
    }

    public void func_73234_b(int x, int z) {
    }
}

