/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.core.util.FileUtils;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.util.FileFilterSchematic;
import java.io.File;
import java.util.LinkedList;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FilenameUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandSchematicaList
extends CommandSchematicaBase {
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);

    public String func_71517_b() {
        return "schematicaList";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.list.usage";
    }

    /*
     * WARNING - void declaration
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        void var15_19;
        File[] files;
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        int page = 0;
        try {
            if (args.length > 0 && (page = Integer.parseInt(args[0]) - 1) < 0) {
                page = 0;
            }
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        int pageSize = 9;
        int pageStart = page * 9;
        int pageEnd = pageStart + 9;
        int currentFile = 0;
        LinkedList<TextComponentString> componentsToSend = new LinkedList<TextComponentString>();
        File schematicDirectory = Schematica.proxy.getPlayerSchematicDirectory(player, true);
        if (schematicDirectory == null) {
            Reference.logger.warn("Unable to determine the schematic directory for player {}", (Object)player);
            throw new CommandException("schematica.command.save.playerSchematicDirUnavailable", new Object[0]);
        }
        if (!schematicDirectory.exists() && !schematicDirectory.mkdirs()) {
            Reference.logger.warn("Could not create player schematic directory {}", (Object)schematicDirectory.getAbsolutePath());
            throw new CommandException("schematica.command.save.playerSchematicDirUnavailable", new Object[0]);
        }
        File[] fileArray = files = schematicDirectory.listFiles(FILE_FILTER_SCHEMATIC);
        int n = fileArray.length;
        boolean bl = false;
        while (var15_19 < n) {
            File path = fileArray[var15_19];
            if (currentFile >= pageStart && currentFile < pageEnd) {
                String fileName = path.getName();
                TextComponentString chatComponent = new TextComponentString(String.format("%2d (%s): %s [", currentFile + 1, FileUtils.humanReadableByteCount((long)path.length()), FilenameUtils.removeExtension((String)fileName)));
                String removeCommand = String.format("/%s %s", "schematicaRemove", fileName);
                TextComponentTranslation removeLink = this.withStyle(new TextComponentTranslation("schematica.command.list.remove", new Object[0]), TextFormatting.RED, removeCommand);
                chatComponent.func_150257_a((ITextComponent)removeLink);
                chatComponent.func_150258_a("][");
                String downloadCommand = String.format("/%s %s", "schematicaDownload", fileName);
                TextComponentTranslation downloadLink = this.withStyle(new TextComponentTranslation("schematica.command.list.download", new Object[0]), TextFormatting.GREEN, downloadCommand);
                chatComponent.func_150257_a((ITextComponent)downloadLink);
                chatComponent.func_150258_a("]");
                componentsToSend.add(chatComponent);
            }
            ++currentFile;
            ++var15_19;
        }
        if (currentFile == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("schematica.command.list.noSchematics", new Object[0]));
            return;
        }
        int totalPages = (currentFile - 1) / 9;
        if (page > totalPages) {
            throw new CommandException("schematica.command.list.noSuchPage", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)this.withStyle(new TextComponentTranslation("schematica.command.list.header", new Object[]{page + 1, totalPages + 1}), TextFormatting.DARK_GREEN, null));
        for (ITextComponent iTextComponent : componentsToSend) {
            sender.func_145747_a(iTextComponent);
        }
    }
}

