/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler.client;

import com.github.lunatrius.schematica.client.gui.control.GuiSchematicControl;
import com.github.lunatrius.schematica.client.gui.load.GuiSchematicLoad;
import com.github.lunatrius.schematica.client.gui.save.GuiSchematicSave;
import com.github.lunatrius.schematica.client.printer.SchematicPrinter;
import com.github.lunatrius.schematica.client.renderer.RenderSchematic;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class InputHandler {
    public static final InputHandler INSTANCE = new InputHandler();
    private static final KeyBinding KEY_BINDING_LOAD = new KeyBinding("schematica.key.load", 181, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_SAVE = new KeyBinding("schematica.key.save", 55, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_CONTROL = new KeyBinding("schematica.key.control", 74, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_LAYER_INC = new KeyBinding("schematica.key.layerInc", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_LAYER_DEC = new KeyBinding("schematica.key.layerDec", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_LAYER_TOGGLE = new KeyBinding("schematica.key.layerToggle", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_RENDER_TOGGLE = new KeyBinding("schematica.key.renderToggle", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_PRINTER_TOGGLE = new KeyBinding("schematica.key.printerToggle", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_MOVE_HERE = new KeyBinding("schematica.key.moveHere", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_PICK_BLOCK = new KeyBinding("schematica.key.pickBlock", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, -98, "schematica.key.category");
    public static final KeyBinding[] KEY_BINDINGS = new KeyBinding[]{KEY_BINDING_LOAD, KEY_BINDING_SAVE, KEY_BINDING_CONTROL, KEY_BINDING_LAYER_INC, KEY_BINDING_LAYER_DEC, KEY_BINDING_LAYER_TOGGLE, KEY_BINDING_RENDER_TOGGLE, KEY_BINDING_PRINTER_TOGGLE, KEY_BINDING_MOVE_HERE, KEY_BINDING_PICK_BLOCK};
    private final Minecraft minecraft = Minecraft.func_71410_x();

    private InputHandler() {
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent event) {
        if (this.minecraft.field_71462_r == null) {
            SchematicWorld schematic;
            if (KEY_BINDING_LOAD.func_151468_f()) {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicLoad(this.minecraft.field_71462_r));
            }
            if (KEY_BINDING_SAVE.func_151468_f()) {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicSave(this.minecraft.field_71462_r));
            }
            if (KEY_BINDING_CONTROL.func_151468_f()) {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicControl(this.minecraft.field_71462_r));
            }
            if (KEY_BINDING_LAYER_INC.func_151468_f() && (schematic = ClientProxy.schematic) != null && schematic.layerMode != SchematicWorld.LayerMode.ALL) {
                schematic.renderingLayer = MathHelper.func_76125_a((int)(schematic.renderingLayer + 1), (int)0, (int)(schematic.func_72800_K() - 1));
                RenderSchematic.INSTANCE.refresh();
            }
            if (KEY_BINDING_LAYER_DEC.func_151468_f() && (schematic = ClientProxy.schematic) != null && schematic.layerMode != SchematicWorld.LayerMode.ALL) {
                schematic.renderingLayer = MathHelper.func_76125_a((int)(schematic.renderingLayer - 1), (int)0, (int)(schematic.func_72800_K() - 1));
                RenderSchematic.INSTANCE.refresh();
            }
            if (KEY_BINDING_LAYER_TOGGLE.func_151468_f() && (schematic = ClientProxy.schematic) != null) {
                schematic.layerMode = SchematicWorld.LayerMode.next(schematic.layerMode);
                RenderSchematic.INSTANCE.refresh();
            }
            if (KEY_BINDING_RENDER_TOGGLE.func_151468_f() && (schematic = ClientProxy.schematic) != null) {
                schematic.isRendering = !schematic.isRendering;
                RenderSchematic.INSTANCE.refresh();
            }
            if (KEY_BINDING_PRINTER_TOGGLE.func_151468_f() && ClientProxy.schematic != null) {
                boolean printing = SchematicPrinter.INSTANCE.togglePrinting();
                this.minecraft.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("schematica.message.togglePrinter", new Object[]{I18n.func_135052_a((String)(printing ? "schematica.gui.on" : "schematica.gui.off"), (Object[])new Object[0])}));
            }
            if (KEY_BINDING_MOVE_HERE.func_151468_f() && (schematic = ClientProxy.schematic) != null) {
                ClientProxy.moveSchematicToPlayer(schematic);
                RenderSchematic.INSTANCE.refresh();
            }
            if (KEY_BINDING_PICK_BLOCK.func_151468_f() && (schematic = ClientProxy.schematic) != null && schematic.isRendering) {
                this.pickBlock(schematic, ClientProxy.objectMouseOver);
            }
        }
    }

    private boolean pickBlock(SchematicWorld schematic, RayTraceResult objectMouseOver) {
        if (objectMouseOver == null) {
            return false;
        }
        if (objectMouseOver.field_72313_a == RayTraceResult.Type.MISS) {
            return false;
        }
        EntityPlayerSP player = this.minecraft.field_71439_g;
        if (!ForgeHooks.onPickBlock((RayTraceResult)objectMouseOver, (EntityPlayer)player, (World)schematic)) {
            return true;
        }
        if (player.field_71075_bZ.field_75098_d) {
            int slot = player.field_71069_bz.field_75151_b.size() - 10 + player.field_71071_by.field_70461_c;
            this.minecraft.field_71442_b.func_78761_a(player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c), slot);
            return true;
        }
        return false;
    }
}

