/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.schematica.command.CommandSchematicaDownload;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.PlayerHandler;
import com.github.lunatrius.schematica.proxy.CommonProxy;
import com.github.lunatrius.schematica.reference.Reference;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class ServerProxy
extends CommonProxy {
    private WeakReference<MinecraftServer> serverWeakReference = null;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)PlayerHandler.INSTANCE);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        super.serverStarting(event);
        event.registerServerCommand((ICommand)new CommandSchematicaDownload());
        this.serverWeakReference = new WeakReference<MinecraftServer>(event.getServer());
    }

    @Override
    public File getDataDirectory() {
        MinecraftServer server = this.serverWeakReference != null ? (MinecraftServer)this.serverWeakReference.get() : null;
        File file = server != null ? server.func_71209_f(".") : new File(".");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            Reference.logger.warn("Could not canonize path!", (Throwable)e);
            return file;
        }
    }

    @Override
    public boolean loadSchematic(EntityPlayer player, File directory, String filename) {
        return false;
    }

    @Override
    public boolean isPlayerQuotaExceeded(EntityPlayer player) {
        int spaceUsed = 0;
        File schematicDirectory = this.getPlayerSchematicDirectory(player, true);
        spaceUsed += this.getSpaceUsedByDirectory(schematicDirectory);
        schematicDirectory = this.getPlayerSchematicDirectory(player, false);
        return (spaceUsed += this.getSpaceUsedByDirectory(schematicDirectory)) / 1024 > ConfigurationHandler.playerQuotaKilobytes;
    }

    private int getSpaceUsedByDirectory(File directory) {
        int spaceUsed = 0;
        if (directory == null || !directory.exists()) {
            return 0;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        for (File path : files) {
            spaceUsed = (int)((long)spaceUsed + path.length());
        }
        return spaceUsed;
    }

    @Override
    public File getPlayerSchematicDirectory(EntityPlayer player, boolean privateDirectory) {
        UUID playerId = player.func_110124_au();
        if (playerId == null) {
            Reference.logger.warn("Unable to identify player {}", (Object)player.toString());
            return null;
        }
        File playerDir = new File(ConfigurationHandler.schematicDirectory.getAbsolutePath(), playerId.toString());
        if (privateDirectory) {
            return new File(playerDir, "private");
        }
        return new File(playerDir, "public");
    }
}

