/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.signbutton;

import gigaherz.signbutton.ModSignButton;
import gigaherz.signbutton.TileSignButton;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSignButton
extends BlockSign {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockSignButton() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setRegistryName("sign_button");
        this.func_149663_c("sign_button");
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSignButton();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModSignButton.itemSignButton);
    }

    public int func_149738_a(World worldIn) {
        return 30;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        float width = 1.0f;
        float height = 0.5f;
        float thick = powered ? 0.0625f : 0.125f;
        float down = 1.0f - thick;
        float left = (1.0f - width) / 2.0f;
        float right = 1.0f - left;
        float bottom = (1.0f - height) / 2.0f;
        float top = 1.0f - bottom;
        switch (enumfacing) {
            case WEST: {
                return new AxisAlignedBB(0.0, (double)bottom, (double)left, (double)thick, (double)top, (double)right);
            }
            case EAST: {
                return new AxisAlignedBB((double)down, (double)bottom, (double)left, 1.0, (double)top, (double)right);
            }
            case NORTH: {
                return new AxisAlignedBB((double)left, (double)bottom, 0.0, (double)right, (double)top, (double)thick);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)left, (double)bottom, (double)down, (double)right, (double)top, 1.0);
            }
            case DOWN: {
                return new AxisAlignedBB((double)left, 0.0, (double)bottom, (double)right, (double)thick, (double)top);
            }
            case UP: {
                return new AxisAlignedBB((double)left, (double)down, (double)bottom, (double)right, 1.0, (double)top);
            }
        }
        return field_185506_k;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        BlockPos pos1 = pos.func_177972_a(side.func_176734_d());
        return worldIn.func_180495_p(pos1).func_193401_d((IBlockAccess)worldIn, pos1, side) == BlockFaceShape.SOLID;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.func_176198_a(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.func_176198_a(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        }
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.func_176198_a(world, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing.func_176734_d());
        }
        return this.func_176223_P();
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing;
        if (this.checkForDrop(worldIn, pos, state) && !this.func_176198_a(worldIn, pos, (enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return true;
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        worldIn.func_175704_b(pos, pos);
        worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        this.notifyNeighbors(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) == false ? 0 : (blockState.func_177229_b((IProperty)FACING) == side.func_176734_d() ? 15 : 0);
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            this.notifyNeighbors(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
            worldIn.func_175704_b(pos, pos);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177972_a(facing.func_176734_d()), (Block)this, false);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        int f = meta & 7;
        if (f > EnumFacing.field_82609_l.length) {
            f = 0;
        }
        EnumFacing enumfacing = EnumFacing.field_82609_l[f];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public Item func_180660_a(IBlockState state, Random rnd, int fortune) {
        return ModSignButton.itemSignButton;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

