/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.items;

import edivad.solargeneration.Main;
import edivad.solargeneration.tools.ItemNBTHelper;
import edivad.solargeneration.tools.ModelCustomArmour;
import edivad.solargeneration.tools.MyEnergyStorage;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolarHelmet
extends ItemArmor {
    private SolarPanelLevel levelSolarHelmet;
    private MyEnergyStorage energyStorage;
    private int energyGeneration;
    private int maxEnergyOutput;

    public SolarHelmet(SolarPanelLevel levelSolarHelmet) {
        super(ItemArmor.ArmorMaterial.IRON, 0, EntityEquipmentSlot.HEAD);
        this.levelSolarHelmet = levelSolarHelmet;
        this.setRegistryName(levelSolarHelmet.getHelmetResourceLocation());
        this.func_77655_b("solargeneration." + levelSolarHelmet.getHelmetResourceLocation().func_110623_a());
        this.func_77637_a(Main.solarGenerationTab);
        this.func_77625_d(1);
        this.energyGeneration = (int)Math.pow(8.0, levelSolarHelmet.ordinal());
        this.maxEnergyOutput = this.energyGeneration * 2;
        this.energyStorage = new MyEnergyStorage(this.energyGeneration * 2, this.energyGeneration * 1000);
    }

    public boolean func_77645_m() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Tooltip.showInfoCtrl(this.getEnergyStored(stack), tooltip);
        Tooltip.showInfoShift(this.levelSolarHelmet, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (itemStack != ItemStack.field_190927_a && itemStack.func_77973_b() instanceof ItemArmor) {
            ModelCustomArmour model = new ModelCustomArmour();
            model.field_78116_c.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            model.field_78091_s = _default.field_78091_s;
            model.field_78093_q = _default.field_78093_q;
            model.field_78117_n = _default.field_78117_n;
            model.field_187076_m = _default.field_187076_m;
            model.field_187075_l = _default.field_187075_l;
            return model;
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "solargeneration:textures/models/armor/solar_helmet_" + this.levelSolarHelmet.name().toLowerCase() + ".png";
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored();
    }

    public void saveEnergyItem(ItemStack container) {
        ItemNBTHelper.setInteger(container, "energy", this.energyStorage.getEnergyStored());
    }

    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger(container, "energy", 0);
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getEnergyStored(itemStack) != this.getMaxEnergyStored()) {
            this.energyStorage.generatePower(this.currentAmountEnergyProduced(world, player));
        }
        this.sendEnergy(world, player);
        this.saveEnergyItem(itemStack);
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.energyStorage.setEnergy(0);
            this.saveEnergyItem(stack);
        } else {
            this.energyStorage.setEnergy(this.getEnergyStored(stack));
        }
        return super.getEquipmentSlot(stack);
    }

    private void sendEnergy(World world, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            IEnergyStorage handler;
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (slot.func_190916_E() != 1 || !slot.hasCapability(CapabilityEnergy.ENERGY, null) || (handler = (IEnergyStorage)slot.getCapability(CapabilityEnergy.ENERGY, null)) == null || !handler.canReceive()) continue;
            int accepted = Math.min(this.maxEnergyOutput, handler.receiveEnergy(this.energyStorage.getEnergyStored(), true));
            this.energyStorage.consumePower(accepted);
            handler.receiveEnergy(accepted, false);
            if (this.energyStorage.getEnergyStored() <= 0) break;
        }
    }

    private int currentAmountEnergyProduced(World world, EntityPlayer player) {
        if (!this.energyStorage.isFullEnergy()) {
            BlockPos pos = new BlockPos(player.field_71094_bP, player.field_71095_bQ + 1.0, player.field_71085_bR);
            return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(world, pos, this.levelSolarHelmet));
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

