/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tile;

import edivad.solargeneration.blocks.containers.SolarPanelContainer;
import edivad.solargeneration.compat.waila.WailaInfoProvider;
import edivad.solargeneration.gui.SolarPanelGui;
import edivad.solargeneration.tools.MyEnergyStorage;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.inter.IGuiTile;
import edivad.solargeneration.tools.inter.IRestorableTileEntity;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarPanel
extends TileEntity
implements ITickable,
IGuiTile,
IRestorableTileEntity,
WailaInfoProvider {
    private MyEnergyStorage energyStorage;
    private int energyGeneration;
    private int maxEnergyOutput;
    private int clientEnergy = -1;
    private int clientCurrentAmountEnergyProduced = -1;
    private SolarPanelLevel levelSolarPanel;

    public TileEntitySolarPanel(SolarPanelLevel levelSolarPanel) {
        this.levelSolarPanel = levelSolarPanel;
        this.energyGeneration = (int)Math.pow(8.0, levelSolarPanel.ordinal());
        this.maxEnergyOutput = this.energyGeneration * 2;
        this.energyStorage = new MyEnergyStorage(this.maxEnergyOutput, this.energyGeneration * 1000);
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.energyStorage.isFullEnergy()) {
            this.energyStorage.generatePower(this.currentAmountEnergyProduced());
            this.func_70296_d();
        }
        this.sendEnergy();
    }

    public int currentAmountEnergyProduced() {
        if (!this.energyStorage.isFullEnergy()) {
            return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(this.field_145850_b, this.func_174877_v(), this.getLevelSolarPanel()));
        }
        return 0;
    }

    private void sendEnergy() {
        for (int i = 0; i < EnumFacing.values().length && this.energyStorage.getEnergyStored() > 0; ++i) {
            IEnergyStorage handler;
            EnumFacing face = EnumFacing.values()[i];
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
            if (tileEntity == null || !tileEntity.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d()) || (handler = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) == null || !handler.canReceive()) continue;
            int received = handler.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), this.maxEnergyOutput), false);
            this.energyStorage.consumePower(received);
            this.func_70296_d();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getClientEnergy() {
        return this.clientEnergy;
    }

    public void setClientEnergy(int clientEnergy) {
        this.clientEnergy = clientEnergy;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergyGeneration() {
        return this.energyGeneration;
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarPanel;
    }

    public int getClientCurrentAmountEnergyProduced() {
        return this.clientCurrentAmountEnergyProduced;
    }

    public void setClientCurrentAmountEnergyProduced(int energy) {
        this.clientCurrentAmountEnergyProduced = energy;
    }

    @Override
    public Container createContainer(EntityPlayer player) {
        return new SolarPanelContainer(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(EntityPlayer player) {
        return new SolarPanelGui(this, new SolarPanelContainer(this));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readRestorableFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeRestorableToNBT(compound);
        return compound;
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound compound) {
        this.energyStorage.setEnergy(compound.func_74762_e("energy"));
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.energyStorage.getEnergyStored());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip.add(TextFormatting.GRAY + "Energy stored: " + this.currentAmountEnergyProduced() + " FE");
        return currenttip;
    }
}

