/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockVariantDrawers
extends BlockStandardDrawers {
    public static final PropertyEnum<BlockPlanks.EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockPlanks.EnumType.class);

    public BlockVariantDrawers(String registryName, String blockName) {
        super(registryName, blockName);
    }

    @Override
    protected void initDefaultState() {
        super.initDefaultState();
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)BlockPlanks.EnumType.OAK));
    }

    @Override
    protected ItemStack getMainDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        ItemStack drop = super.getMainDrop(world, pos, state);
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return drop;
        }
        NBTTagCompound data = drop.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        BlockPlanks.EnumType material = this.translateMaterial(tile.getMaterialOrDefault());
        data.func_74778_a("material", material.func_176610_l());
        drop.func_77982_d(data);
        return drop;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            for (BlockPlanks.EnumType material : BlockPlanks.EnumType.values()) {
                ItemStack stack = new ItemStack((Block)this, 1, type.getMetadata());
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("material", material.func_176610_l());
                stack.func_77982_d(data);
                if (!StorageDrawers.config.cache.creativeTabVanillaWoods && material != BlockPlanks.EnumType.OAK) continue;
                list.add((Object)stack);
            }
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BLOCK, VARIANT, FACING}, new IUnlistedProperty[]{STATE_MODEL});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity(worldIn, pos);
        if (tile == null) {
            return state;
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a(VARIANT, (Comparable)this.translateMaterial(tile.getMaterialOrDefault()));
    }

    @Override
    public boolean retrimBlock(World world, BlockPos pos, ItemStack prototype) {
        BlockPlanks.EnumType newVariant;
        int protoMeta;
        if (this.retrimType() == null) {
            return false;
        }
        IBlockState curState = this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos);
        if (curState == null || !(curState.func_177230_c() instanceof BlockDrawers)) {
            return false;
        }
        Block protoBlock = Block.func_149634_a((Item)prototype.func_77973_b());
        IBlockState newState = protoBlock.func_176203_a(protoMeta = prototype.func_77952_i());
        if (newState == null || !(newState.func_177230_c() instanceof BlockTrim)) {
            return false;
        }
        BlockPlanks.EnumType curVariant = (BlockPlanks.EnumType)curState.func_177229_b(VARIANT);
        if (curVariant == (newVariant = (BlockPlanks.EnumType)newState.func_177229_b(VARIANT))) {
            return false;
        }
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        tile.setMaterial(newVariant.func_176610_l());
        world.func_175656_a(pos, curState.func_177226_a(VARIANT, (Comparable)newVariant));
        return true;
    }

    private BlockPlanks.EnumType translateMaterial(String material) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            if (!material.equals(type.func_176610_l())) continue;
            return type;
        }
        return BlockPlanks.EnumType.OAK;
    }
}

