/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IFrameable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryContainerProxy;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotCraftResult;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotRestricted;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ContainerFramingTable
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private static final int InputX = 23;
    private static final int InputY = 35;
    private static final int MaterialSideX = 50;
    private static final int MaterialSideY = 17;
    private static final int MaterialTrimX = 102;
    private static final int MaterialTrimY = 17;
    private static final int MaterialFrontX = 50;
    private static final int MaterialFrontY = 53;
    private static final int OutputX = 133;
    private static final int OutputY = 35;
    private IInventory tableInventory;
    private IInventory craftResult = new InventoryCraftResult();
    private Slot inputSlot;
    private Slot materialSideSlot;
    private Slot materialTrimSlot;
    private Slot materialFrontSlot;
    private Slot outputSlot;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerFramingTable(InventoryPlayer inventory, TileEntityFramingTable tileEntity) {
        int i;
        this.tableInventory = new InventoryContainerProxy(tileEntity, this);
        this.inputSlot = this.func_75146_a(new SlotRestricted(this.tableInventory, 0, 23, 35));
        this.materialSideSlot = this.func_75146_a(new SlotRestricted(this.tableInventory, 1, 50, 17));
        this.materialTrimSlot = this.func_75146_a(new SlotRestricted(this.tableInventory, 2, 102, 17));
        this.materialFrontSlot = this.func_75146_a(new SlotRestricted(this.tableInventory, 3, 50, 53));
        this.outputSlot = this.func_75146_a(new FramingSlotResult(inventory.field_70458_d, this.tableInventory, this.craftResult, new int[]{0, 1, 2, 3}, 0, 4, 133, 35));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 142)));
        }
        this.func_75130_a(this.tableInventory);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tableInventory.func_70300_a(player);
    }

    public void func_75130_a(IInventory inventory) {
        Item item;
        ItemStack input = this.tableInventory.func_70301_a(this.inputSlot.getSlotIndex()).func_77946_l();
        ItemStack matSide = this.tableInventory.func_70301_a(this.materialSideSlot.getSlotIndex()).func_77946_l();
        ItemStack matTrim = this.tableInventory.func_70301_a(this.materialTrimSlot.getSlotIndex()).func_77946_l();
        ItemStack matFront = this.tableInventory.func_70301_a(this.materialFrontSlot.getSlotIndex()).func_77946_l();
        input.func_190920_e(1);
        matSide.func_190920_e(1);
        matTrim.func_190920_e(1);
        matFront.func_190920_e(1);
        if (!input.func_190926_b() && (item = input.func_77973_b()) instanceof IFrameable) {
            IFrameable frameable = (IFrameable)item;
            if (!matSide.func_190926_b()) {
                this.craftResult.func_70299_a(0, frameable.decorate(input, matSide, matTrim, matFront));
                return;
            }
        }
        this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex == this.outputSlot.field_75222_d) {
                if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, itemStack);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd) {
                boolean merged = false;
                if (TileEntityFramingTable.isItemValidDrawer(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.inputSlot.field_75222_d, this.inputSlot.field_75222_d + 1, false);
                } else if (TileEntityFramingTable.isItemValidMaterial(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.materialSideSlot.field_75222_d, this.materialFrontSlot.field_75222_d + 1, false);
                }
                if (!merged && (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false))) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, false)) {
                return ItemStack.field_190927_a;
            }
            int slotStackSize = slotStack.func_190916_E();
            if (slotStackSize == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStackSize == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return itemStack;
    }

    public static class FramingSlotResult
    extends SlotCraftResult {
        private final IInventory inputInventory;
        private final int alwaysConsumeSlot;

        public FramingSlotResult(EntityPlayer player, IInventory inputInventory, IInventory inventory, int[] inputSlots, int alwaysConsumeSlot, int slot, int x, int y) {
            super(player, inputInventory, inventory, inputSlots, slot, x, y);
            this.inputInventory = inputInventory;
            this.alwaysConsumeSlot = alwaysConsumeSlot;
        }

        @Override
        @Nonnull
        public ItemStack func_190901_a(EntityPlayer player, @Nonnull ItemStack stack) {
            if (StorageDrawers.config.cache.consumeDecorationItems) {
                return super.func_190901_a(player, stack);
            }
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, stack, this.inputInventory);
            this.func_75208_c(stack);
            this.inputInventory.func_70298_a(this.alwaysConsumeSlot, 1);
            return stack;
        }
    }
}

