/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.ward.storage;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thecodex6824.thaumicaugmentation.api.event.BlockWardEvent;
import thecodex6824.thaumicaugmentation.api.ward.storage.ClientWardStorageValue;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageClient;

public class WardStorageClient
implements IWardStorageClient {
    protected StorageManagersClient.IWardStorageManagerClient manager = new StorageManagersClient.StorageManagerNull();

    @Override
    public void setWard(BlockPos pos, ClientWardStorageValue val) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockWardEvent.WardedClient.Pre event = new BlockWardEvent.WardedClient.Pre((World)world, pos, val);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (this.manager.isNullStorage()) {
                this.manager = new StorageManagersClient.StorageManager2Bits();
            }
            this.manager.setOwner(pos, val);
            MinecraftForge.EVENT_BUS.post((Event)new BlockWardEvent.WardedClient.Post((World)world, pos, val));
        }
    }

    @Override
    public void clearWard(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockWardEvent.DewardedClient.Pre event = new BlockWardEvent.DewardedClient.Pre((World)world, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.manager.setOwner(pos, ClientWardStorageValue.EMPTY);
            MinecraftForge.EVENT_BUS.post((Event)new BlockWardEvent.DewardedClient.Post((World)world, pos));
        }
    }

    @Override
    public void clearAllWards() {
        this.manager.clearAll();
    }

    @Override
    public ClientWardStorageValue getWard(BlockPos pos) {
        return this.manager.getOwner(pos);
    }

    @Override
    public boolean hasWard(BlockPos pos) {
        return this.getWard(pos) != ClientWardStorageValue.EMPTY;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.manager = new StorageManagersClient.StorageManager2Bits(nbt.func_74770_j("d"));
    }

    private static final class StorageManagersClient {
        public static final int CHUNK_X_SIZE = 16;
        public static final int CHUNK_Y_SIZE = 256;
        public static final int CHUNK_Z_SIZE = 16;
        public static final int CHUNK_DATA_SIZE = 65536;

        private StorageManagersClient() {
        }

        public static class StorageManager2Bits
        implements IWardStorageManagerClient {
            private byte[] data;

            public StorageManager2Bits() {
                this.data = new byte[16384];
            }

            public StorageManager2Bits(byte[] input) {
                this.data = input;
                if (this.data.length != 16384) {
                    throw new RuntimeException("Invalid ward storage size");
                }
            }

            @Override
            public ClientWardStorageValue getOwner(BlockPos pos) {
                int index = (pos.func_177958_n() & 0xF) + (pos.func_177956_o() & 0xFF) * 16 + (pos.func_177952_p() & 0xF) * 16 * 256;
                int result = (this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2;
                return ClientWardStorageValue.fromID((byte)result);
            }

            @Override
            public void setOwner(BlockPos pos, ClientWardStorageValue owner) {
                byte id = owner.getID();
                int index = (pos.func_177958_n() & 0xF) + (pos.func_177956_o() & 0xFF) * 16 + (pos.func_177952_p() & 0xF) * 16 * 256;
                this.data[index / 4] = (id & 1) != 0 ? (byte)(this.data[index / 4] | 1 << index % 4 * 2) : (byte)(this.data[index / 4] & ~(1 << index % 4 * 2));
                this.data[index / 4] = (id & 2) != 0 ? (byte)(this.data[index / 4] | 2 << index % 4 * 2) : (byte)(this.data[index / 4] & ~(2 << index % 4 * 2));
            }

            @Override
            public void clearAll() {
                Arrays.fill(this.data, 0, this.data.length, (byte)0);
            }

            @Override
            public boolean isNullStorage() {
                return false;
            }
        }

        public static class StorageManagerNull
        implements IWardStorageManagerClient {
            @Override
            public void setOwner(BlockPos pos, ClientWardStorageValue owner) {
            }

            @Override
            public ClientWardStorageValue getOwner(BlockPos pos) {
                return ClientWardStorageValue.EMPTY;
            }

            @Override
            public boolean isNullStorage() {
                return true;
            }

            @Override
            public void clearAll() {
            }
        }

        public static interface IWardStorageManagerClient {
            public ClientWardStorageValue getOwner(BlockPos var1);

            public void setOwner(BlockPos var1, ClientWardStorageValue var2);

            public boolean isNullStorage();

            public void clearAll();
        }
    }
}

