/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ProviderModel
implements IModel {
    protected ImmutableMap<ResourceLocation, ResourceLocation> models;
    protected Function<ItemStack, ResourceLocation> lookup;

    protected ProviderModel(ImmutableMap<ResourceLocation, ResourceLocation> m, Function<ItemStack, ResourceLocation> l) {
        this.models = m;
        this.lookup = l;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public Collection<ResourceLocation> getDependencies() {
        return new ArrayList<ResourceLocation>((Collection<ResourceLocation>)this.models.values());
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelState)state);
        SimpleModelState transformedState = new SimpleModelState(transforms);
        IBakedModel missingModel = ModelLoaderRegistry.getMissingModel().bake((IModelState)transformedState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : this.models.entrySet()) {
            IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)((ResourceLocation)entry.getValue()));
            if (model == ModelLoaderRegistry.getMissingModel()) continue;
            builder.put((Object)((ResourceLocation)entry.getKey()).toString(), (Object)model.bake((IModelState)transformedState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
        return new BakedModel(missingModel, (ImmutableMap<String, IBakedModel>)builder.build(), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, this.lookup);
    }

    public static class BakedModel
    implements IBakedModel {
        protected IBakedModel wrappedFallback;
        protected ImmutableMap<String, IBakedModel> baked;
        protected ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform;
        protected Function<ItemStack, ResourceLocation> lookup;
        protected ItemOverrideList handler = new ItemOverrideList((List)ImmutableList.of()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (IBakedModel)baked.getOrDefault((Object)lookup.apply(stack).toString(), (Object)wrappedFallback);
            }
        };

        protected BakedModel(IBakedModel wrappedModel, ImmutableMap<String, IBakedModel> bakedModels, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms, Function<ItemStack, ResourceLocation> l) {
            this.wrappedFallback = wrappedModel;
            this.baked = bakedModels;
            this.transform = itemTransforms;
            this.lookup = l;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return Collections.emptyList();
        }

        public ItemOverrideList func_188617_f() {
            return this.handler;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.wrappedFallback.func_177554_e();
        }

        public boolean func_177555_b() {
            return this.wrappedFallback.func_177555_b();
        }

        public boolean func_188618_c() {
            return this.wrappedFallback.func_188618_c();
        }

        public boolean func_177556_c() {
            return this.wrappedFallback.func_177556_c();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.wrappedFallback.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transform, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        protected ResourceLocation accepted;
        protected Supplier<Iterable<ResourceLocation>> all;
        protected Function<ItemStack, ResourceLocation> lookup;

        public Loader(ResourceLocation acceptedLoc, Supplier<Iterable<ResourceLocation>> allProviders, Function<ItemStack, ResourceLocation> stackLookup) {
            this.accepted = acceptedLoc;
            this.all = allProviders;
            this.lookup = stackLookup;
        }

        public boolean accepts(ResourceLocation loc) {
            return loc.func_110624_b().equals(this.accepted.func_110624_b()) && loc.func_110623_a().equals(this.accepted.func_110623_a());
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ResourceLocation l : this.all.get()) {
                builder.put((Object)l, (Object)new ResourceLocation(l.func_110624_b(), "item/" + l.func_110623_a()));
            }
            return new ProviderModel((ImmutableMap<ResourceLocation, ResourceLocation>)builder.build(), this.lookup);
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

