/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.renderer.texture;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import thaumcraft.api.aspects.Aspect;

public class TCBannerToElytraTexture
extends AbstractTexture {
    protected static final ResourceLocation ELYTRA_TEXTURE = new ResourceLocation("minecraft", "textures/entity/elytra.png");
    protected ResourceLocation texture;
    protected Aspect aspect;
    protected int color;

    public TCBannerToElytraTexture(ResourceLocation tex) {
        this(tex, null, 0);
    }

    public TCBannerToElytraTexture(ResourceLocation tex, @Nullable Aspect symbol, int baseColor) {
        this.texture = tex;
        this.aspect = symbol;
        this.color = baseColor;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        try (IResource resource = resourceManager.func_110536_a(this.texture);){
            BufferedImage banner = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            if ((this.color & 0x11FFFFFF) > 0) {
                for (int y = 0; y < banner.getHeight(); ++y) {
                    for (int x = 0; x < banner.getWidth(); ++x) {
                        int c = (this.color & 0xFF0000) << 8 & 0xFF000000;
                        int orig = banner.getRGB(x, y);
                        int nC = MathHelper.func_180188_d((int)orig, (int)this.color) & 0xFFFFFF;
                        banner.setRGB(x, y, c | nC | orig & 0xFF000000);
                    }
                }
            }
            if (this.aspect != null) {
                try (IResource a = resourceManager.func_110536_a(this.aspect.getImage());){
                    BufferedImage as = TextureUtil.func_177053_a((InputStream)a.func_110527_b());
                    BufferedImage temp = new BufferedImage(16, 16, 2);
                    Graphics2D t2d = temp.createGraphics();
                    t2d.drawImage(as, 0, 0, 16, 16, null);
                    t2d.dispose();
                    for (int y = 0; y < temp.getHeight(); ++y) {
                        for (int x = 0; x < temp.getWidth(); ++x) {
                            temp.setRGB(x, y, this.aspect.getColor() | temp.getRGB(x, y) & 0xFF000000);
                        }
                    }
                    Graphics2D g2d = banner.createGraphics();
                    g2d.drawImage((Image)temp, 38, 16, null);
                    g2d.dispose();
                }
            }
            try (IResource elytraResource = resourceManager.func_110536_a(ELYTRA_TEXTURE);){
                int x;
                int y;
                BufferedImage elytra = TextureUtil.func_177053_a((InputStream)elytraResource.func_110527_b());
                BufferedImage cutout = new BufferedImage(banner.getWidth(), banner.getHeight(), banner.getType());
                Graphics2D cg2d = cutout.createGraphics();
                cg2d.setTransform(AffineTransform.getScaleInstance(2.0, 2.0));
                cg2d.drawImage((Image)elytra, -18, 0, null);
                cg2d.dispose();
                BufferedImage img = new BufferedImage(banner.getWidth(), banner.getHeight(), banner.getType());
                int lowestX = cutout.getWidth();
                int lowestY = cutout.getHeight();
                for (y = 0; y < Math.min(img.getHeight(), cutout.getHeight()); ++y) {
                    for (x = 0; x < Math.min(img.getWidth(), cutout.getWidth()); ++x) {
                        if ((cutout.getRGB(x, y) & 0xFF000000) == 0) continue;
                        if (x < lowestX) {
                            lowestX = x;
                        }
                        if (y >= lowestY) continue;
                        lowestY = y;
                    }
                }
                for (y = 0; y < Math.min(img.getHeight(), cutout.getHeight()); ++y) {
                    for (x = 0; x < Math.min(img.getWidth(), cutout.getWidth()); ++x) {
                        if ((cutout.getRGB(x, y) & 0xFF000000) == 0) continue;
                        img.setRGB(x - lowestX, y - lowestY, banner.getRGB(x, y));
                    }
                }
                if (this.aspect == null) {
                    Graphics2D g2d = img.createGraphics();
                    g2d.drawImage(img, 0, 21, 2, 44, 26, 4, 28, 26, null);
                    g2d.dispose();
                }
                BufferedImage complete = new BufferedImage((int)((double)elytra.getWidth() * 0.75), (int)((double)elytra.getHeight() * 1.5), img.getType());
                complete.createGraphics().drawImage((Image)img, 0, 0, null);
                TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)complete);
            }
        }
    }
}

