/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;

public abstract class EntityAITargetAnyLiving
extends EntityAIBase {
    protected final EntityLiving entity;
    protected boolean sight;
    protected int targetUnseenTicks;
    protected EntityLivingBase target;
    protected int unseenMemoryTicks;

    public EntityAITargetAnyLiving(EntityLiving living, boolean checkSight) {
        this.entity = living;
        this.sight = checkSight;
    }

    protected boolean isSuitableTarget(@Nullable EntityLivingBase check, boolean includeInvincibles) {
        if (check == null || check == this.entity || !check.func_70089_S()) {
            return false;
        }
        if (!this.entity.func_70686_a(check.getClass()) || this.entity.func_184191_r((Entity)check)) {
            return false;
        }
        if (this.entity instanceof IEntityOwnable && ((IEntityOwnable)this.entity).func_184753_b() != null) {
            IEntityOwnable ownable = (IEntityOwnable)this.entity;
            if (check instanceof IEntityOwnable && ((IEntityOwnable)check).func_184753_b().equals(ownable.func_184753_b())) {
                return false;
            }
            if (check == ownable.func_70902_q()) {
                return false;
            }
        } else if (check instanceof EntityPlayer && !includeInvincibles && ((EntityPlayer)check).field_71075_bZ.field_75102_a) {
            return false;
        }
        return !this.sight || this.entity.func_70635_at().func_75522_a((Entity)check);
    }

    public void func_75249_e() {
        this.unseenMemoryTicks = 300;
        this.targetUnseenTicks = 0;
    }

    protected double getTargetDistance() {
        IAttributeInstance attribute = this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attribute == null ? 16.0 : attribute.func_111126_e();
    }

    public boolean func_75253_b() {
        EntityLivingBase t = this.entity.func_70638_az();
        if (t == null) {
            t = this.target;
        }
        if (t == null) {
            return false;
        }
        if (!t.func_70089_S()) {
            return false;
        }
        Team myTeam = this.entity.func_96124_cp();
        Team theirTeam = t.func_96124_cp();
        if (myTeam != null && myTeam == theirTeam) {
            return false;
        }
        double dist = this.getTargetDistance();
        if (this.entity.func_70068_e((Entity)t) > dist * dist) {
            return false;
        }
        if (this.sight) {
            if (this.entity.func_70635_at().func_75522_a((Entity)t)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) {
                return false;
            }
        }
        if (t instanceof EntityPlayer && ((EntityPlayer)t).field_71075_bZ.field_75102_a) {
            return false;
        }
        this.entity.func_70624_b(t);
        return true;
    }

    public void func_75251_c() {
        this.entity.func_70624_b(null);
        this.target = null;
    }
}

