/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.internal;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.items.casters.foci.FocusMediumTouch;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.event.EntityInOuterLandsEvent;
import thecodex6824.thaumicaugmentation.api.event.FluxRiftDestroyBlockEvent;
import thecodex6824.thaumicaugmentation.api.event.FocusTouchGetEntityEvent;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.common.event.AugmentEventHandler;
import thecodex6824.thaumicaugmentation.common.item.trait.IElytraCompat;
import thecodex6824.thaumicaugmentation.common.network.PacketBaubleChange;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;
import thecodex6824.thaumicaugmentation.common.world.ChunkGeneratorEmptiness;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

public final class TAHooksCommon {
    private TAHooksCommon() {
    }

    private static boolean hasWard(World world, BlockPos pos) {
        IWardStorage ward;
        Chunk chunk;
        if (world != null && pos != null && world.func_72863_F() != null && world.func_175667_e(pos) && (chunk = world.func_175726_f(pos)) != null && (ward = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null)) != null) {
            return ward.hasWard(pos);
        }
        return false;
    }

    public static float checkWardHardness(float oldHardness, World world, BlockPos pos) {
        return TAHooksCommon.hasWard(world, pos) ? -1.0f : oldHardness;
    }

    public static float checkWardResistance(float oldResistance, World world, BlockPos pos) {
        return TAHooksCommon.hasWard(world, pos) ? 6000000.0f : oldResistance;
    }

    public static int checkWardFlammability(int oldFlammability, IBlockAccess access, BlockPos pos) {
        if (oldFlammability == 0) {
            return 0;
        }
        if (access instanceof World) {
            return TAHooksCommon.hasWard((World)access, pos) ? 0 : oldFlammability;
        }
        return oldFlammability;
    }

    public static int checkWardFireEncouragement(int oldEncouragement, IBlockAccess access, BlockPos pos) {
        if (oldEncouragement == 0) {
            return 0;
        }
        if (access instanceof World) {
            return TAHooksCommon.hasWard((World)access, pos) ? 0 : oldEncouragement;
        }
        return oldEncouragement;
    }

    public static boolean checkWardRandomTick(WorldServer world, BlockPos pos, IBlockState state, Random rand) {
        return !TAHooksCommon.hasWard((World)world, pos);
    }

    public static boolean checkWardGeneric(World world, BlockPos pos) {
        return !TAHooksCommon.hasWard(world, pos);
    }

    private static boolean isCompatibleSlab(World world, BlockPos pos, EnumFacing dir, ItemStack slab) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177227_a().contains(BlockSlab.field_176554_a) && state.func_177230_c() instanceof BlockSlab) {
            BlockSlab block = (BlockSlab)state.func_177230_c();
            Comparable item = block.func_185674_a(slab);
            if (dir == EnumFacing.UP && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM || dir == EnumFacing.DOWN && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                Comparable value = state.func_177229_b(block.func_176551_l());
                try {
                    return item.compareTo(value) == 0;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean checkWardSlab(World world, BlockPos pos, EnumFacing placeDir, ItemStack stack) {
        if (placeDir.func_176740_k() == EnumFacing.Axis.Y && TAHooksCommon.isCompatibleSlab(world, pos, placeDir, stack)) {
            return !TAHooksCommon.hasWard(world, pos) && !TAHooksCommon.hasWard(world, pos.func_177972_a(placeDir));
        }
        return !TAHooksCommon.hasWard(world, pos.func_177972_a(placeDir));
    }

    public static void checkElytra(ItemStack chestArmorStack, EntityPlayerMP player) {
        ItemStack stack;
        IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        if (baubles != null && (stack = baubles.getStackInSlot(BaubleType.BODY.getValidSlots()[0])).func_77973_b() instanceof IElytraCompat && ((IElytraCompat)stack.func_77973_b()).allowElytraFlight((EntityPlayer)player, stack)) {
            player.func_184847_M();
        }
    }

    public static boolean updateElytraFlag(EntityLivingBase entity, boolean flag) {
        ItemStack stack;
        EntityPlayer player;
        IBaublesItemHandler baubles;
        if (flag) {
            return true;
        }
        if (entity instanceof EntityPlayer && (baubles = (IBaublesItemHandler)(player = (EntityPlayer)entity).getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) != null && (stack = baubles.getStackInSlot(BaubleType.BODY.getValidSlots()[0])).func_77973_b() instanceof IElytraCompat) {
            return ((IElytraCompat)stack.func_77973_b()).allowElytraFlight(player, stack);
        }
        return false;
    }

    public static ItemStack getLeftoverInfusionIngredientStack(ItemStack input, Object output) {
        if (output instanceof ItemStack && input.func_77973_b() != ItemsTC.primordialPearl) {
            if (((ItemStack)output).func_77973_b() == TAItems.MORPHIC_TOOL) {
                return ItemStack.field_190927_a;
            }
            if (MorphicArmorHelper.hasMorphicArmor((ItemStack)output)) {
                return ItemStack.field_190927_a;
            }
        }
        return input;
    }

    public static void onBaubleChanged(@Nullable EntityLivingBase entity) {
        if (entity != null && !entity.func_130014_f_().field_72995_K) {
            AugmentEventHandler.onEquipmentChange(entity);
            PacketBaubleChange pkt = new PacketBaubleChange(entity.func_145782_y());
            TANetwork.INSTANCE.sendToAllTracking((IMessage)pkt, (Entity)entity);
            if (entity instanceof EntityPlayerMP) {
                TANetwork.INSTANCE.sendTo((IMessage)pkt, (EntityPlayerMP)entity);
            }
        }
    }

    public static boolean isInOuterLands(Entity entity) {
        EntityInOuterLandsEvent event = new EntityInOuterLandsEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && entity.func_130014_f_().field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a();
    }

    public static boolean shouldAllowRunicShield(ItemStack stack) {
        return stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
    }

    public static RayTraceResult fireTrajectoryGetEntityEvent(RayTraceResult original, FocusMediumTouch touch, Trajectory trajectory, double range) {
        if (original != null && original.field_72308_g != null) {
            FocusTouchGetEntityEvent.Trajectory event = new FocusTouchGetEntityEvent.Trajectory(touch, trajectory, original, range);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                return event.getRay();
            }
            return new RayTraceResult(null);
        }
        return original;
    }

    public static RayTraceResult fireTargetGetEntityEvent(RayTraceResult original, FocusMediumTouch touch, Trajectory trajectory, double range) {
        if (original != null && original.field_72308_g != null) {
            FocusTouchGetEntityEvent.Target event = new FocusTouchGetEntityEvent.Target(touch, trajectory, original, range);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                return event.getRay();
            }
            return new RayTraceResult(null);
        }
        return original;
    }

    public static boolean fireFluxRiftDestroyBlockEvent(EntityFluxRift rift, BlockPos pos, IBlockState state) {
        return MinecraftForge.EVENT_BUS.post((Event)new FluxRiftDestroyBlockEvent(rift, pos, state));
    }

    public static boolean onAttemptTeleport(EntityLivingBase entity, double origX, double origY, double origZ) {
        if (!entity.func_130014_f_().field_72995_K) {
            MapGenEldritchSpire.Start start;
            WorldServer w = (WorldServer)entity.func_130014_f_();
            BlockPos check = entity.func_180425_c();
            if (w.func_72863_F().func_193413_a((World)w, "EldritchSpire", check) && (start = ((ChunkGeneratorEmptiness)w.func_72863_F().field_186029_c).getSpireStart(check)) != null) {
                IWardStorage storage = (IWardStorage)w.func_175726_f(check).getCapability(CapabilityWardStorage.WARD_STORAGE, null);
                return !(storage instanceof IWardStorageServer) || !((IWardStorageServer)storage).isWardOwner(start.getWard());
            }
        }
        return true;
    }

    public static boolean checkSweepingEdge(EntityPlayer player, ItemStack stack) {
        return stack.func_77973_b() == TAItems.PRIMAL_CUTTER;
    }

    private static int[] getValidMetadata(Item item) {
        IntRBTreeSet visitedMeta = new IntRBTreeSet();
        for (CreativeTabs tab : item.getCreativeTabs()) {
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(tab, stacks);
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() != item) continue;
                visitedMeta.add(stack.func_77960_j());
            }
        }
        return visitedMeta.toIntArray();
    }

    public static ItemStack cycleItemStack(ItemStack fallback, Object thing, int counter) {
        int[] validMeta;
        ItemStack stack;
        if (thing instanceof ItemStack && !(stack = (ItemStack)thing).func_190926_b() && stack.func_77981_g() && stack.func_77960_j() == Short.MAX_VALUE && (validMeta = TAHooksCommon.getValidMetadata(stack.func_77973_b())).length > 0) {
            int timer = 5000 / validMeta.length;
            int metaIndex = (int)(((long)counter + System.currentTimeMillis() / (long)timer) % (long)validMeta.length);
            ItemStack copy = stack.func_77946_l();
            copy.func_77964_b(validMeta[metaIndex]);
            return copy;
        }
        return fallback;
    }

    public static boolean onAddTile(Chunk chunk, BlockPos pos, TileEntity tile) {
        return !tile.hasCapability(CapabilityImpetusNode.IMPETUS_NODE, null) || chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK) != tile;
    }
}

