/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import unilib.external.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import unilib.external.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import unilib.external.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import unilib.external.nonapi.io.github.classgraph.scanspec.ScanSpec;
import unilib.external.nonapi.io.github.classgraph.utils.FileUtils;
import unilib.external.nonapi.io.github.classgraph.utils.LogNode;

class JBossClassLoaderHandler
implements ClassLoaderHandler {
    private JBossClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.jboss.modules.ModuleClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    private static void handleResourceLoader(Object resourceLoader, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        File file;
        if (resourceLoader == null) {
            return;
        }
        Object root = classpathOrderOut.reflectionUtils.getFieldVal(false, resourceLoader, "root");
        String path = JBossClassLoaderHandler.loadJarPathFromClassicVFS(root, classpathOrderOut);
        if (!JBossClassLoaderHandler.isPathExisting(path)) {
            path = JBossClassLoaderHandler.loadJarPathFromNewVFS(root, classpathOrderOut);
        }
        if (path == null && (file = (File)classpathOrderOut.reflectionUtils.getFieldVal(false, resourceLoader, "fileOfJar")) != null) {
            path = file.getAbsolutePath();
        }
        if (path != null) {
            classpathOrderOut.addClasspathEntry((Object)path, classLoader, scanSpec, log);
        } else if (log != null) {
            log.log("Could not determine classpath for ResourceLoader: " + resourceLoader);
        }
    }

    private static boolean isPathExisting(String path) {
        if (path != null && !path.isEmpty()) {
            Path possibleExistingPath = Paths.get(path, new String[0]);
            return Files.exists(possibleExistingPath, new LinkOption[0]) && Files.isRegularFile(possibleExistingPath, new LinkOption[0]);
        }
        return false;
    }

    private static String loadJarPathFromNewVFS(Object root, ClasspathOrder classpathOrderOut) {
        if (root == null) {
            return null;
        }
        Class<?> jbossVFS = JBossClassLoaderHandler.getJBossVFSAccess(root);
        if (jbossVFS == null) {
            return null;
        }
        Object mount = classpathOrderOut.reflectionUtils.invokeStaticMethod(false, jbossVFS, "getMount", root.getClass(), root);
        if (mount == null) {
            return null;
        }
        Object fileSystem = classpathOrderOut.reflectionUtils.invokeMethod(false, mount, "getFileSystem");
        if (fileSystem == null) {
            return null;
        }
        File mountSource = (File)classpathOrderOut.reflectionUtils.invokeMethod(false, fileSystem, "getMountSource");
        if (mountSource == null) {
            return null;
        }
        return mountSource.getAbsolutePath();
    }

    private static Class<?> getJBossVFSAccess(Object root) {
        Class<?> jbossVFS = null;
        try {
            if (root.getClass().getName().contains("org.jboss.vfs")) {
                ClassLoader vfsRootClassloader = root.getClass().getClassLoader();
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(vfsRootClassloader);
            } else {
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            try {
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jbossVFS;
    }

    private static Class<?> loadJBossVFS(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName("org.jboss.vfs.VFS", true, classLoader);
    }

    private static String loadJarPathFromClassicVFS(Object root, ClasspathOrder classpathOrderOut) {
        String path = null;
        File physicalFile = (File)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getPhysicalFile");
        if (physicalFile != null) {
            File file;
            String name = (String)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getName");
            path = name != null ? (FileUtils.canRead(file = new File(physicalFile.getParentFile(), name)) ? file.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
        } else {
            path = (String)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getPathName");
            if (path == null) {
                File file;
                File file2 = root instanceof Path ? ((Path)root).toFile() : (file = root instanceof File ? (File)root : null);
                if (file != null) {
                    path = file.getAbsolutePath();
                }
            }
        }
        return path;
    }

    private static void handleRealModule(Object module, Set<Object> visitedModules, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)classpathOrderOut.reflectionUtils.invokeMethod(false, module, "getClassLoader");
        if (moduleLoader == null) {
            moduleLoader = classLoader;
        }
        if ((vfsResourceLoaders = classpathOrderOut.reflectionUtils.invokeMethod(false, moduleLoader, "getResourceLoaders")) != null) {
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                JBossClassLoaderHandler.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, scanSpec, log);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object module = classpathOrder.reflectionUtils.invokeMethod(false, classLoader, "getModule");
        Object callerModuleLoader = classpathOrder.reflectionUtils.invokeMethod(false, module, "getCallerModuleLoader");
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)classpathOrder.reflectionUtils.getFieldVal(false, callerModuleLoader, "moduleMap");
        Set<Object> moduleMapEntries = moduleMap != null ? moduleMap.entrySet() : Collections.emptySet();
        for (Map.Entry entry : moduleMapEntries) {
            Object val = entry.getValue();
            Object realModule = classpathOrder.reflectionUtils.invokeMethod(false, val, "getModule");
            JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
        }
        Map pathsMap = (Map)classpathOrder.reflectionUtils.invokeMethod(false, module, "getPaths");
        for (Map.Entry ent : pathsMap.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = classpathOrder.reflectionUtils.getFieldVal(false, localLoader, "this$0");
                Object realModule = classpathOrder.reflectionUtils.getFieldVal(false, moduleClassLoader, "module");
                JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
            }
        }
    }
}

