/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.gui.lanserverproperties;

import java.io.IOException;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.tweaks.misc.gui.lanserverproperties.mixin.GuiShareToLanAccessor;
import mod.acgaming.universaltweaks.tweaks.misc.gui.lanserverproperties.mixin.PlayerListAccessor;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiShareToLan;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UTGuiShareToLan
extends GuiShareToLan {
    public static final String ONLINE_MODE_LANG_KEY = "btn.universaltweaks.lanserverproperties.online_mode";
    public static final String ONLINE_MODE_LANG_KEY_DESC = "btn.universaltweaks.lanserverproperties.online_mode_desc";
    public static final String SPAWN_ANIMALS_LANG_KEY = "btn.universaltweaks.lanserverproperties.spawn_animals";
    public static final String SPAWN_NPCS_LANG_KEY = "btn.universaltweaks.lanserverproperties.spawn_npcs";
    public static final String ALLOW_PVP_LANG_KEY = "btn.universaltweaks.lanserverproperties.allow_pvp";
    public static final String ALLOW_FLIGHT_LANG_KEY = "btn.universaltweaks.lanserverproperties.allow_flight";
    public static final String PORT_LANG_KEY = "btn.universaltweaks.lanserverproperties.port";
    public static final String MAX_PLAYERS_LANG_KEY = "btn.universaltweaks.lanserverproperties.max_players";
    protected final GuiScreen field_146598_a;
    protected GuiTextField portTextField = null;
    protected GuiTextField maxPlayersTextField = null;
    protected GuiButton onlineModeButton = null;
    protected GuiButton spawnAnimalsButton = null;
    protected GuiButton spawnNpcsButton = null;
    protected GuiButton allowPvpButton = null;
    protected GuiButton allowFlightButton = null;
    protected boolean onlineMode = true;
    protected boolean spawnAnimals = true;
    protected boolean spawnNpcs = true;
    protected boolean allowPvp = true;
    protected boolean allowFlight = true;

    public static int validatePort(String text) {
        boolean valid = true;
        int port = -1;
        try {
            if (!(text.isEmpty() || (port = Integer.parseInt(text)) >= 0 && port <= 65535)) {
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid ? port : -1;
    }

    public UTGuiShareToLan(GuiScreen lastScreenIn) {
        super(lastScreenIn);
        this.field_146598_a = lastScreenIn;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiButton button = null;
        String msg = I18n.func_135052_a((String)"lanServer.start", (Object[])new Object[0]);
        for (GuiButton widget : this.field_146292_n) {
            if (!widget.field_146126_j.equals(msg)) continue;
            button = widget;
            break;
        }
        if (button == null) {
            UniversalTweaks.LOGGER.info("UTGuiShareToLan ::: Unable to locate start server button!");
            return;
        }
        this.onlineModeButton = new GuiButton(233, this.field_146294_l / 2 - 155, 124, 150, 20, this.getOnlineButtonText());
        this.func_189646_b(this.onlineModeButton);
        this.spawnAnimalsButton = new GuiButton(234, this.field_146294_l / 2 + 5, 124, 150, 20, this.getSpawnAnimalsButtonText());
        this.func_189646_b(this.spawnAnimalsButton);
        this.spawnNpcsButton = new GuiButton(235, this.field_146294_l / 2 + 5, 148, 150, 20, this.getSpawnNpcsButtonText());
        this.func_189646_b(this.spawnNpcsButton);
        this.allowPvpButton = new GuiButton(236, this.field_146294_l / 2 + 5, 172, 150, 20, this.getAllowPvpButtonText());
        this.func_189646_b(this.allowPvpButton);
        this.allowFlightButton = new GuiButton(237, this.field_146294_l / 2 + 5, 196, 150, 20, this.getAllowFlightButtonText());
        this.func_189646_b(this.allowFlightButton);
        this.portTextField = new GuiTextField(238, this.field_146289_q, this.field_146294_l / 2 - 154, this.field_146295_m - 54, 148, 20);
        this.portTextField.func_146180_a("25565");
        this.maxPlayersTextField = new GuiTextField(239, this.field_146289_q, this.field_146294_l / 2 + 6, this.field_146295_m - 54, 148, 20);
        this.maxPlayersTextField.func_146180_a("4");
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 101) {
            this.serverStartButtonClick(button);
        } else if (button.field_146127_k == 233) {
            this.onlineMode = !this.onlineMode;
            button.field_146126_j = this.getOnlineButtonText();
        } else if (button.field_146127_k == 234) {
            this.spawnAnimals = !this.spawnAnimals;
            button.field_146126_j = this.getSpawnAnimalsButtonText();
        } else if (button.field_146127_k == 235) {
            this.spawnNpcs = !this.spawnNpcs;
            button.field_146126_j = this.getSpawnNpcsButtonText();
        } else if (button.field_146127_k == 236) {
            this.allowPvp = !this.allowPvp;
            button.field_146126_j = this.getAllowPvpButtonText();
        } else if (button.field_146127_k == 237) {
            this.allowFlight = !this.allowFlight;
            button.field_146126_j = this.getAllowFlightButtonText();
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)PORT_LANG_KEY, (Object[])new Object[0]), this.field_146294_l / 2 - 155, this.field_146295_m - 66, 0xA0A0A0);
        this.portTextField.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)MAX_PLAYERS_LANG_KEY, (Object[])new Object[0]), this.field_146294_l / 2 + 5, this.field_146295_m - 66, 0xA0A0A0);
        this.maxPlayersTextField.func_146194_f();
        if (this.onlineModeButton.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)ONLINE_MODE_LANG_KEY_DESC, (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.portTextField.func_146201_a(typedChar, keyCode)) {
            this.portTextField.func_146193_g(UTGuiShareToLan.validatePort(this.portTextField.func_146179_b()) >= 0 ? 0xFFFFFF : 0xFF0000);
        } else if (this.maxPlayersTextField.func_146201_a(typedChar, keyCode)) {
            this.maxPlayersTextField.func_146193_g(UTGuiShareToLan.validatePort(this.maxPlayersTextField.func_146179_b()) >= 0 ? 0xFFFFFF : 0xFF0000);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.portTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.maxPlayersTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    private void serverStartButtonClick(GuiButton button) throws IOException {
        TextComponentString textComponent;
        this.field_146297_k.func_147108_a(null);
        String portStr = this.portTextField.func_146179_b();
        int port = !portStr.isEmpty() ? Integer.parseInt(portStr) : 25565;
        String maxPlayersStr = this.maxPlayersTextField.func_146179_b();
        int maxPlayers = !maxPlayersStr.isEmpty() ? Integer.parseInt(maxPlayersStr) : 4;
        String gameMode = ((GuiShareToLanAccessor)((Object)this)).getGameMode();
        boolean allowCheats = ((GuiShareToLanAccessor)((Object)this)).getAllowCheats();
        String newPort = this.field_146297_k.func_71401_C().func_71206_a(GameType.func_77142_a((String)gameMode), allowCheats);
        if (newPort != null) {
            this.field_146297_k.func_71401_C().func_147137_ag().func_151265_a(null, port);
            textComponent = new TextComponentTranslation("commands.publish.started", new Object[]{newPort + ", " + port});
            this.field_146297_k.func_71401_C().func_71229_d(this.onlineMode);
            this.field_146297_k.func_71401_C().func_71251_e(this.spawnAnimals);
            this.field_146297_k.func_71401_C().func_71257_f(this.spawnNpcs);
            this.field_146297_k.func_71401_C().func_71188_g(this.allowPvp);
            this.field_146297_k.func_71401_C().func_71245_h(this.allowFlight);
            ((PlayerListAccessor)this.field_146297_k.func_71401_C().func_184103_al()).setMaxPlayers(maxPlayers);
        } else {
            textComponent = new TextComponentString("commands.publish.failed");
        }
        this.field_146297_k.field_71456_v.func_146158_b().func_146227_a((ITextComponent)textComponent);
    }

    private String getOnlineButtonText() {
        return I18n.func_135052_a((String)ONLINE_MODE_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.onlineMode ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getSpawnAnimalsButtonText() {
        return I18n.func_135052_a((String)SPAWN_ANIMALS_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.spawnAnimals ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getSpawnNpcsButtonText() {
        return I18n.func_135052_a((String)SPAWN_NPCS_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.spawnNpcs ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getAllowPvpButtonText() {
        return I18n.func_135052_a((String)ALLOW_PVP_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.allowPvp ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getAllowFlightButtonText() {
        return I18n.func_135052_a((String)ALLOW_FLIGHT_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.allowFlight ? "options.on" : "options.off"), (Object[])new Object[0]);
    }
}

