/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionManager;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.player.actions.IActionManager;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVisionRegistry;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronCraftingManager;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import de.teamlapen.vampirism.api.items.IHunterWeaponCraftingManager;
import de.teamlapen.vampirism.api.world.IGarlicChunkHandler;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class VampirismAPI {
    @CapabilityInject(value=IExtendedCreatureVampirism.class)
    private static final Capability<IExtendedCreatureVampirism> CAP_CREATURE = null;
    @CapabilityInject(value=IFactionPlayerHandler.class)
    private static final Capability<IFactionPlayerHandler> CAP_FACTION_HANDLER_PLAYER = null;
    @CapabilityInject(value=IVampirismVillage.class)
    private static final Capability<IVampirismVillage> CAP_VILLAGE = null;
    private static IFactionRegistry factionRegistry;
    private static ISundamageRegistry sundamageRegistry;
    private static IVampirismEntityRegistry entityRegistry;
    private static IVampireVisionRegistry vampireVisionRegistry;
    private static IHunterWeaponCraftingManager weaponCraftingManager;
    private static IBloodPotionRegistry bloodPotionRegistry;
    private static IGarlicChunkHandler.Provider garlicHandlerProvider;
    private static IAlchemicalCauldronCraftingManager alchemicalCauldronCraftingManager;
    private static Set<Integer> worldGenDimensions;
    private static ISkillManager skillManager;
    private static IActionManager actionManager;
    private static IEntityActionManager entityActionManager;

    public static ISkillManager skillManager() {
        return skillManager;
    }

    public static IActionManager actionManager() {
        return actionManager;
    }

    public static IEntityActionManager entityActionManager() {
        return entityActionManager;
    }

    public static IVampireVisionRegistry vampireVisionRegistry() {
        return vampireVisionRegistry;
    }

    public static IFactionRegistry factionRegistry() {
        return factionRegistry;
    }

    public static ISundamageRegistry sundamageRegistry() {
        return sundamageRegistry;
    }

    public static IVampirismEntityRegistry entityRegistry() {
        return entityRegistry;
    }

    @Deprecated
    public static IVampirismEntityRegistry biteableRegistry() {
        return entityRegistry;
    }

    public static IHunterWeaponCraftingManager weaponCraftingManager() {
        return weaponCraftingManager;
    }

    public static IBloodPotionRegistry bloodPotionRegistry() {
        return bloodPotionRegistry;
    }

    public static IAlchemicalCauldronCraftingManager alchemicalCauldronCraftingManager() {
        return alchemicalCauldronCraftingManager;
    }

    public static void addDimensionForWorldgen(int id) {
        worldGenDimensions.add(id);
    }

    public static void removeDimensionFromWorldgen(int id) {
        worldGenDimensions.remove(id);
    }

    public static boolean isWorldGenEnabledFor(int dim) {
        return worldGenDimensions.contains(dim);
    }

    public static void setUpRegistries(IFactionRegistry factionReg, ISundamageRegistry sundamageReg, IVampirismEntityRegistry biteableReg, IActionManager actionMan, ISkillManager skillMan, IVampireVisionRegistry vampireVisionReg, IBloodPotionRegistry bloodPotionReg, IEntityActionManager entityActionMan) {
        factionRegistry = factionReg;
        sundamageRegistry = sundamageReg;
        entityRegistry = biteableReg;
        actionManager = actionMan;
        skillManager = skillMan;
        vampireVisionRegistry = vampireVisionReg;
        bloodPotionRegistry = bloodPotionReg;
        entityActionManager = entityActionMan;
    }

    public static void setUpAccessors(IHunterWeaponCraftingManager weaponCraftingMan, IGarlicChunkHandler.Provider garlicChunkHandlerProv, IAlchemicalCauldronCraftingManager alchemicalCauldronCraftingMan) {
        weaponCraftingManager = weaponCraftingMan;
        garlicHandlerProvider = garlicChunkHandlerProv;
        alchemicalCauldronCraftingManager = alchemicalCauldronCraftingMan;
    }

    public static IFactionPlayerHandler getFactionPlayerHandler(EntityPlayer player) {
        return (IFactionPlayerHandler)player.getCapability(CAP_FACTION_HANDLER_PLAYER, null);
    }

    public static IExtendedCreatureVampirism getExtendedCreatureVampirism(EntityCreature creature) {
        return (IExtendedCreatureVampirism)creature.getCapability(CAP_CREATURE, null);
    }

    public static IVampirismVillage getVampirismVillage(Village village) {
        return (IVampirismVillage)village.getCapability(CAP_VILLAGE, null);
    }

    @Nonnull
    public static IGarlicChunkHandler getGarlicChunkHandler(World world) {
        return garlicHandlerProvider.getHandler(world);
    }

    static {
        worldGenDimensions = Sets.newHashSet();
    }
}

