/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.lib.lib.util.InventoryRenderHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.ItemCrossbowArrow;
import de.teamlapen.vampirism.items.ItemVampireCloak;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModItemsRender {
    public static void register() {
        ModItemsRender.registerRenderers();
    }

    static void registerColors() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return ((ItemArmor)stack.func_77973_b()).func_82814_b(stack);
            }
            switch (ModItems.armor_of_swiftness_feet.getTier(stack)) {
                case ENHANCED: {
                    return 31999;
                }
                case ULTIMATE: {
                    return 522495;
                }
            }
            return 0xFFF100;
        }, new Item[]{ModItems.armor_of_swiftness_feet, ModItems.armor_of_swiftness_chest, ModItems.armor_of_swiftness_head, ModItems.armor_of_swiftness_legs});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 1) {
                return ItemCrossbowArrow.getType((ItemStack)stack).color;
            }
            return 0xFFFFFF;
        }, new Item[]{ModItems.crossbow_arrow});
    }

    private static void registerRenderers() {
        VampirismMod.log.d("ModItemsRender", "Registering renderer", new Object[0]);
        InventoryRenderHelper renderHelper = new InventoryRenderHelper("vampirism");
        renderHelper.registerRender(ModItems.vampire_fang, "normal");
        renderHelper.registerRender((Item)ModItems.human_heart, "normal");
        renderHelper.registerRender((Item)ModItems.weak_human_heart, "normal");
        renderHelper.registerRender(ModItems.item_tent, "normal");
        renderHelper.registerRenderAllMeta((Item)ModItems.blood_bottle, 10);
        renderHelper.registerRender(ModItems.item_coffin, "normal");
        renderHelper.registerRenderAllMeta((Item)ModItems.pure_blood, 6);
        renderHelper.registerRenderAllMeta(ModItems.hunter_intel, HunterLevelingConf.instance().HUNTER_INTEL_COUNT, "normal");
        renderHelper.registerRender(ModItems.item_garlic, "normal");
        renderHelper.registerRenderAllMeta((Item)ModItems.injection, 3);
        renderHelper.registerRender(ModItems.item_med_chair, "normal");
        renderHelper.registerRender(ModItems.pitchfork, "normal");
        renderHelper.registerRender(ModItems.basic_crossbow, "normal");
        renderHelper.registerRender(ModItems.crossbow_arrow, "normal");
        renderHelper.registerRender(ModItems.basic_double_crossbow, "normal");
        renderHelper.registerRender(ModItems.enhanced_crossbow, "normal");
        renderHelper.registerRender(ModItems.enhanced_double_crossbow, "normal");
        renderHelper.registerRender(ModItems.stake, "normal");
        renderHelper.registerRender(ModItems.vampire_blood_bottle, "normal");
        renderHelper.registerRender(ModItems.blood_potion, "normal");
        renderHelper.registerRender(ModItems.basic_tech_crossbow, "normal");
        renderHelper.registerRender(ModItems.enhanced_tech_crossbow, "normal");
        renderHelper.registerRender(ModItems.tech_crossbow_ammo_package, "normal");
        renderHelper.registerRender(ModItems.vampire_book, "normal");
        renderHelper.registerRender((Item)ModItems.hunter_hat0_head, "normal");
        renderHelper.registerRender((Item)ModItems.hunter_hat1_head, "normal");
        ModItemsRender.registerSimpleItemWithTier(ModItems.holy_water_bottle);
        renderHelper.registerRender(ModItems.holy_salt, "normal");
        renderHelper.registerRender(ModItems.pure_salt, "normal");
        renderHelper.registerRender(ModItems.holy_salt_water, "normal");
        renderHelper.registerRender(ModItems.item_alchemical_fire, "normal");
        renderHelper.registerRender(ModItems.garlic_beacon_core, "normal");
        renderHelper.registerRender(ModItems.garlic_beacon_core_improved, "normal");
        renderHelper.registerRender(ModItems.purified_garlic, "normal");
        ModItemsRender.registerSimpleItemWithTier(ModItems.holy_water_bottle);
        ModItemsRender.registerSimpleItemWithTier(ModItems.holy_water_splash_bottle);
        ModItemsRender.registerSimpleItemWithTier(ModItems.hunter_axe);
        ModItemsRender.registerArmorItemWithTier(ModItems.armor_of_swiftness_head, "swiftness_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.armor_of_swiftness_chest, "swiftness_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.armor_of_swiftness_legs, "swiftness_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.armor_of_swiftness_feet, "swiftness_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunter_coat_head, "hunter_coat");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunter_coat_chest, "hunter_coat");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunter_coat_legs, "hunter_coat");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunter_coat_feet, "hunter_coat");
        ModItemsRender.registerArmorItemWithTier(ModItems.obsidian_armor_head, "obsidian_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.obsidian_armor_chest, "obsidian_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.obsidian_armor_legs, "obsidian_armor");
        ModItemsRender.registerArmorItemWithTier(ModItems.obsidian_armor_feet, "obsidian_armor");
        ModItemsRender.registerSimpleItemWithTier(ModItems.heart_seeker);
        ModItemsRender.registerSimpleItemWithTier(ModItems.heart_striker);
        renderHelper.registerRender(ModItems.blood_infused_iron_ingot, "normal");
        renderHelper.registerRender(ModItems.blood_infused_enhanced_iron_ingot, "normal");
        renderHelper.registerRender(ModItems.soul_orb_vampire, "normal");
        ModItemsRender.registerVampireCloakWithColor((Item)ModItems.vampire_cloak, "vampire_cloak");
        renderHelper.registerRender((Item)ModItems.garlic_bread, "normal");
    }

    private static void registerSimpleItemWithTier(IItemWithTier itemWithTier) {
        Item item = (Item)itemWithTier;
        ResourceLocation loc = new ResourceLocation("vampirism", "item/" + item.getRegistryName().func_110623_a());
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new IItemWithTier.SimpleMeshDefinition(loc));
        for (IItemWithTier.TIER s : IItemWithTier.TIER.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(loc, "tier=" + s.func_176610_l())});
        }
    }

    private static void registerArmorItemWithTier(IItemWithTier armorWithTier, String baseName) {
        ItemArmor item = (ItemArmor)armorWithTier;
        ResourceLocation loc = new ResourceLocation("vampirism", "item/" + baseName);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new IItemWithTier.ArmorMeshDefinition(loc));
        for (IItemWithTier.TIER s : IItemWithTier.TIER.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(loc, "part=" + item.field_77881_a.func_188450_d() + "_" + s.func_176610_l())});
        }
    }

    private static void registerVampireCloakWithColor(Item item, String baseName) {
        for (ItemVampireCloak.EnumCloakColor e : ItemVampireCloak.EnumCloakColor.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)e.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("vampirism", "item/" + baseName), "color=" + e.getDyeColorName()));
        }
    }
}

