/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;

public class InvisibleEntityAction<T extends EntityCreature>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public InvisibleEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public int getCooldown(int level) {
        return Balance.ea.INVISIBLE_COOLDOWN * 20;
    }

    @Override
    public int getDuration(int level) {
        return Balance.ea.INVISIBLE_DURATION * 20;
    }

    @Override
    public void deactivate(T entity) {
        ((IFactionEntity)entity).getRepresentingEntity().func_82142_c(false);
    }

    @Override
    public void onUpdate(T entity, int duration) {
        if (!((IFactionEntity)entity).getRepresentingEntity().func_82150_aj()) {
            ((IFactionEntity)entity).getRepresentingEntity().func_82142_c(true);
        }
    }

    @Override
    public void activate(T entity) {
        VampLib.proxy.getParticleHandler().spawnParticles(entity.func_130014_f_(), ModParticles.GENERIC_PARTICLE, ((EntityCreature)entity).field_70165_t, ((EntityCreature)entity).field_70163_u, ((EntityCreature)entity).field_70161_v, 60, 1.0, entity.func_70681_au(), EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c(), 16, 0xF0F0F0);
    }

    @Override
    public void updatePreAction(T entity, int duration) {
        if (duration % 5 == 0) {
            VampLib.proxy.getParticleHandler().spawnParticles(entity.func_130014_f_(), ModParticles.GENERIC_PARTICLE, ((EntityCreature)entity).field_70165_t, ((EntityCreature)entity).field_70163_u, ((EntityCreature)entity).field_70161_v, 10, 1.0, entity.func_70681_au(), EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c(), 16, 0xF0F0F0);
        }
    }

    @Override
    public int getWeight(T entity) {
        double distanceToTarget = new Vec3d(((EntityCreature)entity).field_70165_t, ((EntityCreature)entity).field_70163_u, ((EntityCreature)entity).field_70161_v).func_178786_a(entity.func_70638_az().field_70165_t, entity.func_70638_az().field_70163_u, entity.func_70638_az().field_70161_v).func_72433_c();
        if (distanceToTarget > 4.0) {
            return 3;
        }
        return 1;
    }
}

