/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class RegenerationAOFEntityAction<T extends EntityCreature>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public RegenerationAOFEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public int getDuration(int level) {
        return Balance.ea.REGENERATION_DURATION * 20;
    }

    @Override
    public int getCooldown(int level) {
        return Balance.ea.REGENERATION_COOLDOWN * 20;
    }

    @Override
    public void deactivate(T entity) {
    }

    @Override
    public void onUpdate(T entity, int duration) {
        List entities = entity.func_130014_f_().func_72872_a(EntityLiving.class, new AxisAlignedBB(((EntityCreature)entity).field_70165_t - 4.0, ((EntityCreature)entity).field_70163_u - 1.0, ((EntityCreature)entity).field_70161_v - 4.0, ((EntityCreature)entity).field_70165_t + 4.0, ((EntityCreature)entity).field_70163_u + 3.0, ((EntityCreature)entity).field_70161_v + 4.0));
        for (EntityLiving e : entities) {
            if (VampirismAPI.factionRegistry().getFaction((Entity)entity) != VampirismAPI.factionRegistry().getFaction((Entity)e)) continue;
            e.func_70691_i(entity.func_110138_aP() / 100.0f * (float)Balance.ea.REGENERATION_AMOUNT / (float)(this.getDuration(((IAdjustableLevel)entity).getLevel()) * 20));
            if (duration % 20 != 0) continue;
            VampLib.proxy.getParticleHandler().spawnParticles(entity.func_130014_f_(), new ResourceLocation("vampirism", "heal"), e.field_70165_t, e.field_70163_u + 1.0, e.field_70161_v, 3, 0.01, new Random(), e);
        }
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void updatePreAction(T entity, int duration) {
    }

    @Override
    public int getWeight(T entity) {
        double healthPercent = entity.func_110143_aJ() / entity.func_110138_aP();
        if (healthPercent < 0.1) {
            return 3;
        }
        if (healthPercent < 0.4) {
            return 2;
        }
        return 1;
    }
}

