/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.EntityVillagerVampirism;
import de.teamlapen.vampirism.entity.ai.EntityAIMoveIndoorsDay;
import de.teamlapen.vampirism.entity.ai.VampireAIBiteNearbyEntity;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.ai.VampireAIMoveToBiteable;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityConvertedVillager
extends EntityVillagerVampirism
implements IConvertedCreature<EntityVillager> {
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;

    public EntityConvertedVillager(World worldIn) {
        super(worldIn);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityPlayer && !UtilLib.canReallySee((EntityLivingBase)entity, (EntityLivingBase)this, true) && this.field_70146_Z.nextInt(Balance.mobProps.VAMPIRE_BITE_ATTACK_CHANCE) == 0) {
            int amt = VampirePlayer.get((EntityPlayer)entity).onBite(this);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        return super.func_70652_k(entity);
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
        this.bloodTimer = -1200 - this.field_70146_Z.nextInt(1200);
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isGettingSundamage() && this.field_70173_aa % 40 == 11) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 42));
            }
            if (this.isGettingGarlicDamage() != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage(), this.field_70173_aa);
            }
        }
        ++this.bloodTimer;
        super.func_70636_d();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.removeIf(entry -> entry.field_75733_a instanceof EntityAIMoveIndoors || entry.field_75733_a instanceof EntityAIVillagerMate || entry.field_75733_a instanceof EntityAIFollowGolem);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreature.class, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, true, false, false, VReference.HUNTER_FACTION), 10.0f, (double)0.45f, (double)0.55f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoorsDay((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, new VampireAIFleeSun<EntityConvertedVillager>(this, (double)0.6f, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)0.6f, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new VampireAIBiteNearbyEntity(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new VampireAIMoveToBiteable(this, 0.55f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    private void addAdditionalRecipes(MerchantRecipeList list) {
        if (list.size() > 0) {
            list.remove(this.field_70146_Z.nextInt(list.size()));
        }
        this.addRecipe(list, new ItemStack((Item)ModItems.human_heart, 9), 2, this.func_70681_au(), 0.5f);
        this.addRecipe(list, 3, new ItemStack((Item)ModItems.human_heart, 9), this.func_70681_au(), 0.5f);
        this.addRecipe(list, 1, new ItemStack((Item)ModItems.blood_bottle, 3, 9), this.field_70146_Z, 0.9f);
    }

    private void addRecipe(MerchantRecipeList list, int emeralds, ItemStack stack, Random rnd, float prop) {
        if (rnd.nextFloat() < prop) {
            list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeralds), stack));
        }
    }

    private void addRecipe(MerchantRecipeList list, ItemStack stack, int emeralds, Random rnd, float prop) {
        if (rnd.nextFloat() < prop) {
            list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeralds), stack));
        }
    }

    public static class ConvertingHandler
    implements IConvertingHandler<EntityVillager> {
        @Override
        public IConvertedCreature<EntityVillager> createFrom(EntityVillager entity) {
            NBTTagCompound nbt = new NBTTagCompound();
            entity.func_189511_e(nbt);
            EntityConvertedVillager converted = new EntityConvertedVillager(entity.field_70170_p);
            converted.func_70020_e(nbt);
            converted.func_184221_a(MathHelper.func_180182_a((Random)converted.field_70146_Z));
            if (converted.field_70963_i == null) {
                converted.func_175554_cu();
            }
            converted.addAdditionalRecipes(converted.field_70963_i);
            Collections.shuffle(converted.field_70963_i);
            return converted;
        }
    }
}

