/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.entity.converted.BiteableEntryManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    @Nullable
    private static BiteableEntryManager biteableEntryManager;
    private final Map<ResourceLocation, Integer> bloodValues = new HashMap<ResourceLocation, Integer>();
    private final Map<ResourceLocation, Integer> overridingValues = new HashMap<ResourceLocation, Integer>();
    private final Map<Class<? extends EntityCreature>, IConvertingHandler> convertibles = new HashMap<Class<? extends EntityCreature>, IConvertingHandler>();
    private final Map<Class<? extends EntityCreature>, String> convertibleOverlay = new HashMap<Class<? extends EntityCreature>, String>();
    private final Map<Class<? extends EntityCreature>, Function> extendedCreatureConstructors = new HashMap<Class<? extends EntityCreature>, Function>();
    private final String TAG = "VampirismEntityRegistry";
    private boolean finished = false;
    private IVampirismEntityRegistry.ICreateDefaultConvertingHandler defaultConvertingHandlerCreator;

    public static BiteableEntryManager getBiteableEntryManager() {
        return biteableEntryManager;
    }

    @Override
    public void addBloodValue(ResourceLocation entityId, int value) {
        this.bloodValues.put(entityId, value);
    }

    @Override
    public void addBloodValues(Map<ResourceLocation, Integer> values) {
        this.bloodValues.putAll(values);
    }

    @Override
    public void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc) {
        this.addConvertible(clazz, overlay_loc, (IConvertingHandler)null);
    }

    @Override
    public void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc, IConvertingHandler.IDefaultHelper helper) {
        this.addConvertible(clazz, overlay_loc, this.defaultConvertingHandlerCreator.create(helper));
    }

    @Override
    public void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc, IConvertingHandler handler) {
        this.convertibles.put(clazz, handler);
        if (FMLCommonHandler.instance().getSide().isClient() && overlay_loc != null) {
            this.convertibleOverlay.put(clazz, overlay_loc);
        }
    }

    @Override
    public <T extends EntityCreature> void addCustomExtendedCreature(Class<? extends T> clazz, Function<T, IExtendedCreatureVampirism> constructor) {
        this.extendedCreatureConstructors.put(clazz, constructor);
    }

    @Override
    @Nullable
    public IConvertedCreature convert(EntityCreature entity) {
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        BiteableEntry b = biteableEntryManager.get(id);
        if (b != null && b.convertingHandler != null) {
            return b.convertingHandler.createFrom(entity);
        }
        VampirismMod.log.w("VampirismEntityRegistry", "Failed to find convertible entry for %s", entity);
        return null;
    }

    public void finishRegistration() {
        if (this.finished) {
            return;
        }
        HashMap biteables = Maps.newHashMap();
        HashSet blacklist = Sets.newHashSet();
        this.bloodValues.putAll(this.overridingValues);
        float bloodValueMultiplier = 1.0f;
        Integer i = this.bloodValues.get(new ResourceLocation("multiplier"));
        if (i != null) {
            bloodValueMultiplier = (float)i.intValue() / 10.0f;
        }
        IConvertingHandler defaultHandler = this.defaultConvertingHandlerCreator.create(null);
        for (Map.Entry<Class<? extends EntityCreature>, IConvertingHandler> entry : this.convertibles.entrySet()) {
            ResourceLocation id = EntityList.func_191306_a(entry.getKey());
            if (id == null) {
                VampirismMod.log.w("VampirismEntityRegistry", "Cannot register convertible %s since there is no EntityString for it", entry.getKey());
                continue;
            }
            Integer blood = this.bloodValues.remove(id);
            if (blood == null) {
                VampirismMod.log.w("VampirismEntityRegistry", "Missing blood value for convertible creature %s (%s)", entry.getKey().getName(), id);
                continue;
            }
            blood = Math.round((float)blood.intValue() * bloodValueMultiplier);
            VampirismMod.log.i("VampirismEntityRegistry", " Registering convertible %s with blood %d and handler %s", entry.getKey().getName(), blood, entry.getValue());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            biteables.put(id, biteEntry);
        }
        for (Map.Entry<Class<Object>, Object> entry : this.bloodValues.entrySet()) {
            int blood = Math.abs(Math.round((float)((Integer)entry.getValue()).intValue() * bloodValueMultiplier));
            if (blood == 0) {
                blacklist.add(entry.getKey());
                continue;
            }
            biteables.put(entry.getKey(), new BiteableEntry(blood));
        }
        this.bloodValues.clear();
        this.convertibles.clear();
        biteableEntryManager = new BiteableEntryManager(biteables, blacklist);
        this.finished = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<Class<? extends EntityCreature>, String> getConvertibleOverlay() {
        return this.convertibleOverlay;
    }

    @Override
    @Nullable
    public <T extends EntityCreature> Function<T, IExtendedCreatureVampirism> getCustomExtendedCreatureConstructor(T entity) {
        return this.extendedCreatureConstructors.get(entity.getClass());
    }

    @Override
    @Nullable
    public BiteableEntry getEntry(EntityCreature creature) {
        return this.getEntry(EntityList.func_191301_a((Entity)creature));
    }

    @Override
    @Nullable
    public BiteableEntry getEntry(ResourceLocation entity_id) {
        return biteableEntryManager == null ? null : biteableEntryManager.get(entity_id);
    }

    @Override
    public void overrideBloodValues(Map<ResourceLocation, Integer> values) {
        this.overridingValues.putAll(values);
    }

    public void setDefaultConvertingHandlerCreator(IVampirismEntityRegistry.ICreateDefaultConvertingHandler creator) {
        this.defaultConvertingHandlerCreator = creator;
    }
}

