/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.items.ItemCrossbowArrow;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public abstract class VampirismItemCrossbow
extends VampirismItem
implements IFactionLevelItem<IHunterPlayer>,
IVampirismCrossbow {
    private int enchantability = 0;

    public VampirismItemCrossbow(String regName, int maxDamage) {
        super(regName);
        this.field_77777_bU = 1;
        if (maxDamage > 0) {
            this.func_77656_e(maxDamage);
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.enchantability;
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    @Nullable
    public IPlayableFaction<IHunterPlayer> getUsingFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        this.shoot(playerIn, 0.0f, 0.0f, worldIn, stack, handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void setEnchantability(int enchantability) {
        this.enchantability = enchantability;
    }

    public void setEnchantability(Item.ToolMaterial material) {
        this.enchantability = material.func_77995_e();
    }

    @Nonnull
    protected ItemStack findAmmo(EntityPlayer player, ItemStack bowStack) {
        if (this.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected float getArrowVelocity() {
        return 1.0f;
    }

    protected int getCooldown(EntityPlayer player, ItemStack stack) {
        return 20;
    }

    protected boolean isArrow(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IVampirismCrossbowArrow;
    }

    protected boolean isCritical(Random random) {
        return false;
    }

    protected boolean isCrossbowInfinite(ItemStack stack, EntityPlayer player) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.crossbowinfinite, (ItemStack)stack);
        return enchant > 0 || player.func_184812_l_();
    }

    protected static int isCrossbowFrugal(ItemStack crossbowStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.crossbowfrugality, (ItemStack)crossbowStack);
    }

    protected boolean isIgnoreHurtTime(ItemStack crossbow) {
        return false;
    }

    protected boolean shoot(EntityPlayer player, float heightOffset, float centerOffset, World world, ItemStack stack, EnumHand hand) {
        boolean creative = player.field_71075_bZ.field_75098_d;
        boolean bowInfinite = this.isCrossbowInfinite(stack, player);
        int bowFrugal = VampirismItemCrossbow.isCrossbowFrugal(stack);
        ItemStack itemstack = this.findAmmo(player, stack);
        if (!itemstack.func_190926_b() || bowInfinite) {
            float f;
            if (itemstack.func_190926_b()) {
                itemstack = new ItemStack((Item)ModItems.crossbow_arrow);
            }
            if ((double)(f = this.getArrowVelocity()) >= 0.1) {
                boolean consumeArrow = this.shouldConsumeArrow(player.func_70681_au(), itemstack, creative, bowInfinite, bowFrugal);
                if (!world.field_72995_K) {
                    int k;
                    int j;
                    boolean rightHand = player.func_184591_cq() == EnumHandSide.RIGHT && hand == EnumHand.MAIN_HAND || player.func_184591_cq() == EnumHandSide.LEFT && hand == EnumHand.OFF_HAND;
                    ItemCrossbowArrow itemarrow = itemstack.func_77973_b() instanceof IVampirismCrossbowArrow ? (IVampirismCrossbowArrow)itemstack.func_77973_b() : ModItems.crossbow_arrow;
                    Object entityarrow = itemarrow.createEntity(itemstack, world, player, heightOffset, 0.3f + centerOffset, rightHand);
                    entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (this.isCritical(player.func_70681_au())) {
                        entityarrow.func_70243_d(true);
                    }
                    if (this.isIgnoreHurtTime(stack)) {
                        ((IEntityCrossbowArrow)entityarrow).setIgnoreHurtTimer();
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        entityarrow.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (!consumeArrow) {
                        ((EntityArrow)entityarrow).field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_72838_d(entityarrow);
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, ModSounds.crossbow, SoundCategory.PLAYERS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                if (consumeArrow) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(itemstack);
                    }
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.getCooldown(player, stack));
                return true;
            }
        }
        return false;
    }

    protected boolean shouldConsumeArrow(Random rnd, ItemStack arrowStack, boolean playerCreative, boolean bowInfinite, int bowFrugal) {
        return !(playerCreative || bowInfinite && this.canArrowBeInfinite(arrowStack) || bowFrugal > 0 && rnd.nextInt(Math.max(2, 4 - bowFrugal)) == 0);
    }

    private boolean canArrowBeInfinite(ItemStack arrowStack) {
        Item arrow = arrowStack.func_77973_b();
        return !(arrow instanceof IVampirismCrossbowArrow) || ((IVampirismCrossbowArrow)arrow).isCanBeInfinite(arrowStack);
    }
}

