/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.VampirismHUDOverlay;
import de.teamlapen.vampirism.client.render.LayerVampireEntity;
import de.teamlapen.vampirism.client.render.LayerVampirePlayerHead;
import de.teamlapen.vampirism.client.render.RenderHandler;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.proxy.CommonProxy;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final String TAG = "ClientProxy";
    private VampirismHUDOverlay overlay;

    public ClientProxy() {
        RegistryManager.setupClientRegistryManager();
    }

    @Override
    public float getRenderPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    @Override
    public boolean isClientPlayerNull() {
        return Minecraft.func_71410_x().field_71439_g == null;
    }

    @Override
    public boolean isPlayerThePlayer(EntityPlayer player) {
        return Minecraft.func_71410_x().field_71439_g.equals((Object)player);
    }

    @Override
    public void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        super.onInitStep(step, event);
        RegistryManager.getRegistryManagerClient().onInitStep(step, event);
        switch (step) {
            case PRE_INIT: {
                ModKeys.register();
                this.registerSubscriptions();
                break;
            }
            case INIT: {
                break;
            }
            case POST_INIT: {
                this.registerVampireEntityOverlays();
            }
        }
    }

    @Override
    public void renderScreenFullColor(int ticksOn, int ticksOff, int color) {
        if (this.overlay != null) {
            this.overlay.makeRenderFullColor(ticksOn, ticksOff, color);
        }
    }

    @Override
    @Nullable
    public Entity getMouseOverEntity() {
        RayTraceResult r = Minecraft.func_71410_x().field_71476_x;
        if (r == null) {
            return null;
        }
        return r.field_72308_g;
    }

    private void registerSubscriptions() {
        this.overlay = new VampirismHUDOverlay(Minecraft.func_71410_x());
        MinecraftForge.EVENT_BUS.register((Object)this.overlay);
        MinecraftForge.EVENT_BUS.register((Object)new RenderHandler(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    private void registerVampireEntityOverlay(RenderManager manager, Class<? extends EntityCreature> clazz, ResourceLocation loc) {
        Render render = manager.func_78715_a(clazz);
        if (render == null) {
            VampirismMod.log.e(TAG, "Did not find renderer for %s", clazz);
            return;
        }
        if (!(render instanceof RenderLivingBase)) {
            VampirismMod.log.e(TAG, "Renderer (%s) for %s does not extend RenderLivingEntity", clazz, render);
            return;
        }
        RenderLivingBase rendererLiving = (RenderLivingBase)render;
        rendererLiving.func_177094_a((LayerRenderer)new LayerVampireEntity(rendererLiving, loc, true));
    }

    private void registerVampireEntityOverlays() {
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        this.registerVampirePlayerHead(manager);
        for (Map.Entry<Class<? extends EntityCreature>, String> entry : VampirismAPI.entityRegistry().getConvertibleOverlay().entrySet()) {
            this.registerVampireEntityOverlay(manager, entry.getKey(), new ResourceLocation(entry.getValue()));
        }
    }

    private void registerVampirePlayerHead(RenderManager manager) {
        for (RenderPlayer renderPlayer : manager.getSkinMap().values()) {
            renderPlayer.func_177094_a((LayerRenderer)new LayerVampirePlayerHead(renderPlayer));
        }
    }

    @Override
    @Nullable
    public EntityPlayer getSPPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

